/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.PacketCipher;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;

public interface AESCFBModePacketCipher
extends PacketCipher {
    default public void checkCFBParameter(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            KeyParameter keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            if (keyParameter == null) {
                throw new IllegalArgumentException("CFB cipher unitialized");
            }
            int n = keyParameter.getKeyLength();
            if (n < 16 || n > 32 || (n & 7) != 0) {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        } else {
            throw new IllegalArgumentException("CFB cipher unitialized");
        }
    }
}

