/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.PacketCipherException;
import net.jsign.bouncycastle.crypto.engines.AESNativeCFBPacketCipher;
import net.jsign.bouncycastle.crypto.engines.AESPacketCipher;
import net.jsign.bouncycastle.crypto.modes.AESCFBModePacketCipher;
import net.jsign.bouncycastle.crypto.modes.PacketCipherChecks;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.Bytes;

public class AESCFBPacketCipher
implements AESCFBModePacketCipher {
    public static AESCFBModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CFB-PC")) {
            return new AESNativeCFBPacketCipher();
        }
        return new AESCFBPacketCipher();
    }

    protected AESCFBPacketCipher() {
    }

    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        if (cipherParameters instanceof ParametersWithIV) {
            if (((ParametersWithIV)cipherParameters).getIV().length != 16) {
                throw new IllegalArgumentException("iv must be only 16 bytes");
            }
            cipherParameters = ((ParametersWithIV)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            PacketCipherChecks.checkKeyLenIllegalArgumentException(((KeyParameter)cipherParameters).getKeyLength());
        }
        return n;
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        byte[] byArray3;
        Object object;
        PacketCipherChecks.checkBoundsInputAndOutput(byArray, n, n2, byArray2, n3);
        if (n2 == 0) {
            return n2;
        }
        if (cipherParameters instanceof ParametersWithIV) {
            object = (ParametersWithIV)cipherParameters;
            byArray3 = Arrays.clone(((ParametersWithIV)object).getIV());
            if (byArray3.length != 16) {
                throw PacketCipherException.from(new IllegalArgumentException("iv must be only 16 bytes"));
            }
            cipherParameters = ((ParametersWithIV)cipherParameters).getParameters();
        } else {
            byArray3 = new byte[16];
        }
        if (!(cipherParameters instanceof KeyParameter)) {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameter type"));
        }
        object = (KeyParameter)cipherParameters;
        PacketCipherChecks.checkKeyLength(((KeyParameter)object).getKeyLength());
        byte[] byArray4 = Arrays.clone(((KeyParameter)object).getKey());
        object = AESPacketCipher.createS(true);
        int[][] nArray = AESPacketCipher.generateWorkingKey(true, byArray4);
        byte[] byArray5 = new byte[16];
        AESPacketCipher.processBlock(true, nArray, (byte[])object, byArray3, 0, byArray5, 0);
        int n4 = n2;
        if (bl) {
            while (n4 > 16) {
                Bytes.xor(16, byArray, n, byArray5, 0, byArray2, n3);
                AESPacketCipher.processBlock(true, nArray, (byte[])object, byArray2, n3, byArray5, 0);
                n4 -= 16;
                n += 16;
                n3 += 16;
            }
        } else {
            byte[] byArray6 = new byte[16];
            while (n4 > 16) {
                System.arraycopy(byArray, n, byArray6, 0, byArray6.length);
                Bytes.xor(16, byArray, n, byArray5, 0, byArray2, n3);
                AESPacketCipher.processBlock(true, nArray, (byte[])object, byArray6, 0, byArray5, 0);
                n4 -= 16;
                n += 16;
                n3 += 16;
            }
        }
        Bytes.xor(n4, byArray, n, byArray5, 0, byArray2, n3);
        return n2;
    }

    public String toString() {
        return "CFB-PS[Java](AES[Java])";
    }
}

