/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.PacketCipher;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;

public interface AESCTRModePacketCipher
extends PacketCipher {
    default public void checkParameters(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            int n = parametersWithIV.getIV().length;
            if (16 < n) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV no greater than: 16 bytes.");
            }
            if (16 - n > 8) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV of at least: 8 bytes.");
            }
            KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
            if (keyParameter == null) {
                throw new IllegalStateException("CTR/SIC cipher unitialized.");
            }
            int n2 = keyParameter.getKeyLength();
            if (n2 < 16 || n2 > 32 || (n2 & 7) != 0) {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
    }
}

