/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.PacketCipherException;
import net.jsign.bouncycastle.crypto.engines.AESNativeCTRPacketCipher;
import net.jsign.bouncycastle.crypto.engines.AESPacketCipher;
import net.jsign.bouncycastle.crypto.modes.AESCTRModePacketCipher;
import net.jsign.bouncycastle.crypto.modes.PacketCipherChecks;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.Bytes;

public class AESCTRPacketCipher
implements AESCTRModePacketCipher {
    public static AESCTRModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CTR-PC")) {
            return new AESNativeCTRPacketCipher();
        }
        return new AESCTRPacketCipher();
    }

    private AESCTRPacketCipher() {
    }

    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        this.checkParameters(cipherParameters);
        return n;
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        int n4;
        int n5;
        int n6;
        KeyParameter keyParameter;
        byte[] byArray3;
        PacketCipherChecks.checkBoundsInputAndOutput(byArray, n, n2, byArray2, n3);
        if (n2 == 0) {
            return 0;
        }
        byte[] byArray4 = new byte[16];
        byte[] byArray5 = new byte[16];
        byte[] byArray6 = AESPacketCipher.createS(true);
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byArray3 = Arrays.clone(parametersWithIV.getIV());
            if (byArray3.length > 16) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV no greater than: 16 bytes.");
            }
            if (byArray3.length < 8) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV of at least: 8 bytes.");
            }
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
            keyParameter = (KeyParameter)parametersWithIV.getParameters();
            if (keyParameter == null) {
                throw PacketCipherException.from(new IllegalStateException("CTR/SIC cipher unitialized."));
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
        int n7 = keyParameter.getKey().length;
        PacketCipherChecks.checkKeyLength(n7);
        int[][] nArray = AESPacketCipher.generateWorkingKey(true, keyParameter.getKey());
        int n8 = 16 - byArray3.length;
        if (n8 > 0 && n8 < 4 && n2 > (n6 = (n7 = 1 << (n5 = n8 * 8)) * 16)) {
            throw new IllegalStateException("Counter in CTR/SIC mode out of range.");
        }
        for (n4 = n2; n4 > 16; n4 -= 16) {
            AESPacketCipher.processBlock(true, nArray, byArray6, byArray4, 0, byArray5, 0);
            Bytes.xor(16, byArray, n, byArray5, 0, byArray2, n3);
            AESCTRPacketCipher.incrementCounter(byArray4, byArray3);
            n += 16;
            n3 += 16;
        }
        AESPacketCipher.processBlock(true, nArray, byArray6, byArray4, 0, byArray5, 0);
        Bytes.xor(n4, byArray, n, byArray5, 0, byArray2, n3);
        Arrays.clear(byArray5);
        Arrays.clear(byArray4);
        Arrays.clear(byArray3);
        Arrays.clear(nArray);
        Arrays.clear(byArray6);
        return n2;
    }

    private static void incrementCounter(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        while (--n >= 0) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] == 0) continue;
            break;
        }
    }

    public String toString() {
        return "CTR-PS[Java](AES[Java])";
    }
}

