/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.PacketCipher;
import net.jsign.bouncycastle.crypto.params.AEADParameters;
import net.jsign.bouncycastle.crypto.params.KeyParameter;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;

public interface AESGCMSIVModePacketCipher
extends PacketCipher {
    default public void checkParameters(CipherParameters cipherParameters) {
        KeyParameter keyParameter;
        byte[] byArray;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            byArray = aEADParameters.getNonce();
            keyParameter = aEADParameters.getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byArray = Arrays.clone(parametersWithIV.getIV());
            keyParameter = (KeyParameter)parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM-SIV");
        }
        if (byArray == null || byArray.length != 12) {
            throw new IllegalArgumentException("invalid nonce");
        }
        if (keyParameter == null || keyParameter.getKeyLength() != 16 && keyParameter.getKeyLength() != 32) {
            throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
        }
    }
}

