/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.modes;

import net.jsign.bouncycastle.crypto.BlockCipher;
import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.crypto.DataLengthException;
import net.jsign.bouncycastle.crypto.NativeBlockCipherProvider;
import net.jsign.bouncycastle.crypto.OutputLengthException;
import net.jsign.bouncycastle.crypto.StreamBlockCipher;
import net.jsign.bouncycastle.crypto.modes.CTRModeCipher;
import net.jsign.bouncycastle.crypto.params.ParametersWithIV;
import net.jsign.bouncycastle.util.Arrays;

public class SICBlockCipher
extends StreamBlockCipher
implements CTRModeCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private int byteCount;

    public static CTRModeCipher newInstance(BlockCipher blockCipher) {
        if (blockCipher instanceof NativeBlockCipherProvider) {
            return ((NativeBlockCipherProvider)((Object)blockCipher)).createCTR();
        }
        return new SICBlockCipher(blockCipher);
    }

    public SICBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.cipher = blockCipher;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
        this.byteCount = 0;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersWithIV) {
            int n;
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.IV = Arrays.clone(parametersWithIV.getIV());
            if (this.blockSize < this.IV.length) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV no greater than: " + this.blockSize + " bytes.");
            }
            int n2 = n = 8 > this.blockSize / 2 ? this.blockSize / 2 : 8;
            if (this.blockSize - this.IV.length > n) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV of at least: " + (this.blockSize - n) + " bytes.");
            }
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (this.byteCount != 0) {
            this.processBytes(byArray, n, this.blockSize, byArray2, n2);
            return this.blockSize;
        }
        if (n + this.blockSize > byArray.length) {
            throw new DataLengthException("input buffer too small");
        }
        if (n2 + this.blockSize > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        for (int i = 0; i < this.blockSize; ++i) {
            byArray2[n2 + i] = (byte)(byArray[n + i] ^ this.counterOut[i]);
        }
        this.incrementCounter();
        return this.blockSize;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too small");
        }
        if (n3 + n2 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i = 0; i < n2; ++i) {
            byte by;
            if (this.byteCount == 0) {
                this.checkLastIncrement();
                this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
                by = (byte)(byArray[n + i] ^ this.counterOut[this.byteCount++]);
            } else {
                by = (byte)(byArray[n + i] ^ this.counterOut[this.byteCount++]);
                if (this.byteCount == this.counter.length) {
                    this.byteCount = 0;
                    this.incrementCounter();
                }
            }
            byArray2[n3 + i] = by;
        }
        return n2;
    }

    @Override
    protected byte calculateByte(byte by) throws DataLengthException, IllegalStateException {
        if (this.byteCount == 0) {
            this.checkLastIncrement();
            this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
            return (byte)(this.counterOut[this.byteCount++] ^ by);
        }
        byte by2 = (byte)(this.counterOut[this.byteCount++] ^ by);
        if (this.byteCount == this.counter.length) {
            this.byteCount = 0;
            this.incrementCounter();
        }
        return by2;
    }

    private void checkLastIncrement() {
        if (this.IV.length < this.blockSize && this.counter[this.IV.length - 1] != this.IV[this.IV.length - 1]) {
            throw new IllegalStateException("Counter in CTR/SIC mode out of range.");
        }
    }

    private void incrementCounter() {
        int n = this.counter.length;
        while (--n >= 0) {
            int n2 = n;
            this.counter[n2] = (byte)(this.counter[n2] + 1);
            if (this.counter[n2] == 0) continue;
            break;
        }
    }

    @Override
    public void reset() {
        Arrays.fill(this.counter, (byte)0);
        System.arraycopy(this.IV, 0, this.counter, 0, this.IV.length);
        this.cipher.reset();
        this.byteCount = 0;
    }
}

