/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.params;

import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.x9.ECNamedCurveTable;
import net.jsign.bouncycastle.asn1.x9.X9ECParameters;
import net.jsign.bouncycastle.crypto.ec.CustomNamedCurves;
import net.jsign.bouncycastle.crypto.params.ECDomainParameters;

public class ECNamedDomainParameters
extends ECDomainParameters {
    private ASN1ObjectIdentifier name;

    public static ECNamedDomainParameters lookup(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters);
    }

    public ECNamedDomainParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParameters x9ECParameters) {
        super(x9ECParameters);
        this.name = aSN1ObjectIdentifier;
    }

    public ASN1ObjectIdentifier getName() {
        return this.name;
    }
}

