/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.params;

import net.jsign.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.jsign.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import net.jsign.bouncycastle.math.ec.rfc8032.Ed25519;
import net.jsign.bouncycastle.util.Arrays;

public final class Ed25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    private final byte[] data = new byte[32];
    private Ed25519PublicKeyParameters cachedPublicKey;

    public Ed25519PrivateKeyParameters(byte[] byArray, int n) {
        super(true);
        System.arraycopy(byArray, n, this.data, 0, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ed25519PublicKeyParameters generatePublicKey() {
        byte[] byArray = this.data;
        synchronized (this.data) {
            if (null == this.cachedPublicKey) {
                this.cachedPublicKey = new Ed25519PublicKeyParameters(Ed25519.generatePublicKey(this.data, 0));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cachedPublicKey;
        }
    }
}

