/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.params;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jsign.bouncycastle.crypto.CipherParameters;
import net.jsign.bouncycastle.util.Integers;

public class SkeinParameters
implements CipherParameters {
    private Hashtable parameters;

    public SkeinParameters() {
        this(new Hashtable());
    }

    private SkeinParameters(Hashtable hashtable) {
        this.parameters = hashtable;
    }

    public static class Builder {
        private Hashtable parameters = new Hashtable();

        public Builder() {
        }

        public Builder(Hashtable hashtable) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                this.parameters.put(n, hashtable.get(n));
            }
        }

        public Builder set(int n, byte[] byArray) {
            if (byArray == null) {
                throw new IllegalArgumentException("Parameter value must not be null.");
            }
            if (n != 0 && (n < 4 || n >= 63 || n == 48)) {
                throw new IllegalArgumentException("Parameter types must be in the range 0,5..47,49..62.");
            }
            if (n == 4) {
                throw new IllegalArgumentException("Parameter type 4 is reserved for internal use.");
            }
            this.parameters.put(Integers.valueOf(n), byArray);
            return this;
        }

        public Builder setKey(byte[] byArray) {
            return this.set(0, byArray);
        }

        public SkeinParameters build() {
            return new SkeinParameters(this.parameters);
        }
    }
}

