/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.util;

import java.util.HashMap;
import java.util.Map;
import net.jsign.bouncycastle.crypto.CryptoServicePurpose;
import net.jsign.bouncycastle.crypto.Digest;
import net.jsign.bouncycastle.crypto.digests.MD5Digest;
import net.jsign.bouncycastle.crypto.digests.SHA1Digest;
import net.jsign.bouncycastle.crypto.digests.SHA224Digest;
import net.jsign.bouncycastle.crypto.digests.SHA256Digest;
import net.jsign.bouncycastle.crypto.digests.SHA384Digest;
import net.jsign.bouncycastle.crypto.digests.SHA3Digest;
import net.jsign.bouncycastle.crypto.digests.SHA512Digest;
import net.jsign.bouncycastle.crypto.digests.SHAKEDigest;

public final class DigestFactory {
    private static final Map cloneMap = new HashMap();

    public static Digest createMD5() {
        return new MD5Digest();
    }

    public static Digest createMD5PRF() {
        return new MD5Digest();
    }

    public static Digest createSHA1() {
        return new SHA1Digest();
    }

    public static Digest createSHA1PRF() {
        return new SHA1Digest(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA224() {
        return SHA224Digest.newInstance();
    }

    public static Digest createSHA224PRF() {
        return SHA224Digest.newInstance(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA256() {
        return SHA256Digest.newInstance();
    }

    public static Digest createSHA256PRF() {
        return new SHA256Digest(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA384() {
        return SHA384Digest.newInstance();
    }

    public static Digest createSHA384PRF() {
        return SHA384Digest.newInstance(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA512() {
        return SHA512Digest.newInstance();
    }

    public static Digest createSHA512PRF() {
        return SHA512Digest.newInstance(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA3_224() {
        return SHA3Digest.newInstance(224);
    }

    public static Digest createSHA3_224PRF() {
        return SHA3Digest.newInstance(224, CryptoServicePurpose.PRF);
    }

    public static Digest createSHA3_256() {
        return SHA3Digest.newInstance(256);
    }

    public static Digest createSHA3_256PRF() {
        return SHA3Digest.newInstance(256, CryptoServicePurpose.PRF);
    }

    public static Digest createSHA3_384() {
        return SHA3Digest.newInstance(384);
    }

    public static Digest createSHA3_384PRF() {
        return SHA3Digest.newInstance(384, CryptoServicePurpose.PRF);
    }

    public static Digest createSHA3_512() {
        return SHA3Digest.newInstance(512);
    }

    public static Digest createSHA3_512PRF() {
        return SHA3Digest.newInstance(512, CryptoServicePurpose.PRF);
    }

    public static Digest createSHAKE128() {
        return SHAKEDigest.newInstance(128);
    }

    public static Digest createSHAKE256() {
        return SHAKEDigest.newInstance(256);
    }

    static {
        cloneMap.put(DigestFactory.createMD5().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA1().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA224().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA256().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA384().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA512().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA3_224().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA3_256().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA3_384().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHA3_512().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHAKE128().getAlgorithmName(), new Object(){});
        cloneMap.put(DigestFactory.createSHAKE256().getAlgorithmName(), new Object(){});
    }
}

