/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.util;

import java.io.IOException;
import java.math.BigInteger;
import net.jsign.bouncycastle.asn1.ASN1EncodableVector;
import net.jsign.bouncycastle.asn1.ASN1Integer;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.ASN1Sequence;
import net.jsign.bouncycastle.asn1.ASN1TaggedObject;
import net.jsign.bouncycastle.asn1.DERSequence;
import net.jsign.bouncycastle.asn1.nist.NISTNamedCurves;
import net.jsign.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.jsign.bouncycastle.asn1.pkcs.RSAPrivateKey;
import net.jsign.bouncycastle.asn1.sec.ECPrivateKey;
import net.jsign.bouncycastle.asn1.x9.X962Parameters;
import net.jsign.bouncycastle.asn1.x9.X9ECParameters;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.jsign.bouncycastle.crypto.params.DSAParameters;
import net.jsign.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import net.jsign.bouncycastle.crypto.params.ECDomainParameters;
import net.jsign.bouncycastle.crypto.params.ECNamedDomainParameters;
import net.jsign.bouncycastle.crypto.params.ECPrivateKeyParameters;
import net.jsign.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import net.jsign.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import net.jsign.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import net.jsign.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import net.jsign.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import net.jsign.bouncycastle.crypto.util.SSHBuffer;
import net.jsign.bouncycastle.crypto.util.SSHBuilder;
import net.jsign.bouncycastle.crypto.util.SSHNamedCurves;
import net.jsign.bouncycastle.util.Arrays;
import net.jsign.bouncycastle.util.BigIntegers;
import net.jsign.bouncycastle.util.Strings;

public class OpenSSHPrivateKeyUtil {
    static final byte[] AUTH_MAGIC = Strings.toByteArray("openssh-key-v1\u0000");

    public static byte[] encodePrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("param is null");
        }
        if (asymmetricKeyParameter instanceof RSAPrivateCrtKeyParameters) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter);
            return privateKeyInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter);
            return privateKeyInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPrivateKeyParameters.getParameters();
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new ASN1Integer(0L));
            aSN1EncodableVector.add(new ASN1Integer(dSAParameters.getP()));
            aSN1EncodableVector.add(new ASN1Integer(dSAParameters.getQ()));
            aSN1EncodableVector.add(new ASN1Integer(dSAParameters.getG()));
            BigInteger bigInteger = dSAParameters.getG().modPow(dSAPrivateKeyParameters.getX(), dSAParameters.getP());
            aSN1EncodableVector.add(new ASN1Integer(bigInteger));
            aSN1EncodableVector.add(new ASN1Integer(dSAPrivateKeyParameters.getX()));
            try {
                return new DERSequence(aSN1EncodableVector).getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to encode DSAPrivateKeyParameters " + exception.getMessage());
            }
        }
        if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
            Ed25519PublicKeyParameters ed25519PublicKeyParameters = ((Ed25519PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey();
            SSHBuilder sSHBuilder = new SSHBuilder();
            sSHBuilder.writeBytes(AUTH_MAGIC);
            sSHBuilder.writeString("none");
            sSHBuilder.writeString("none");
            sSHBuilder.writeString("");
            sSHBuilder.u32(1);
            Object object = OpenSSHPublicKeyUtil.encodePublicKey(ed25519PublicKeyParameters);
            sSHBuilder.writeBlock((byte[])object);
            object = new SSHBuilder();
            int n = CryptoServicesRegistrar.getSecureRandom().nextInt();
            ((SSHBuilder)object).u32(n);
            ((SSHBuilder)object).u32(n);
            ((SSHBuilder)object).writeString("ssh-ed25519");
            byte[] byArray = ed25519PublicKeyParameters.getEncoded();
            ((SSHBuilder)object).writeBlock(byArray);
            ((SSHBuilder)object).writeBlock(Arrays.concatenate(((Ed25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded(), byArray));
            ((SSHBuilder)object).writeString("");
            sSHBuilder.writeBlock(((SSHBuilder)object).getPaddedBytes());
            return sSHBuilder.getBytes();
        }
        throw new IllegalArgumentException("unable to convert " + asymmetricKeyParameter.getClass().getName() + " to openssh private key");
    }

    public static AsymmetricKeyParameter parsePrivateKeyBlob(byte[] byArray) {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        if (byArray[0] == 48) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
            if (aSN1Sequence.size() == 6) {
                if (OpenSSHPrivateKeyUtil.allIntegers(aSN1Sequence) && ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    asymmetricKeyParameter = new DSAPrivateKeyParameters(((ASN1Integer)aSN1Sequence.getObjectAt(5)).getPositiveValue(), new DSAParameters(((ASN1Integer)aSN1Sequence.getObjectAt(1)).getPositiveValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getPositiveValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(3)).getPositiveValue()));
                }
            } else if (aSN1Sequence.size() == 9) {
                if (OpenSSHPrivateKeyUtil.allIntegers(aSN1Sequence) && ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(aSN1Sequence);
                    asymmetricKeyParameter = new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
                }
            } else if (aSN1Sequence.size() == 4 && aSN1Sequence.getObjectAt(3) instanceof ASN1TaggedObject && aSN1Sequence.getObjectAt(2) instanceof ASN1TaggedObject) {
                ECDomainParameters eCDomainParameters;
                Object object;
                ECPrivateKey eCPrivateKey = ECPrivateKey.getInstance(aSN1Sequence);
                X962Parameters x962Parameters = X962Parameters.getInstance(eCPrivateKey.getParametersObject().toASN1Primitive());
                if (x962Parameters.isNamedCurve()) {
                    object = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
                    eCDomainParameters = ECNamedDomainParameters.lookup((ASN1ObjectIdentifier)object);
                } else {
                    object = X9ECParameters.getInstance(x962Parameters.getParameters());
                    eCDomainParameters = new ECDomainParameters((X9ECParameters)object);
                }
                object = eCPrivateKey.getKey();
                asymmetricKeyParameter = new ECPrivateKeyParameters((BigInteger)object, eCDomainParameters);
            }
        } else {
            int n;
            SSHBuffer sSHBuffer = new SSHBuffer(AUTH_MAGIC, byArray);
            String string = sSHBuffer.readString();
            if (!"none".equals(string)) {
                throw new IllegalStateException("encrypted keys not supported");
            }
            sSHBuffer.skipBlock();
            sSHBuffer.skipBlock();
            int n2 = sSHBuffer.readU32();
            if (n2 != 1) {
                throw new IllegalStateException("multiple keys not supported");
            }
            OpenSSHPublicKeyUtil.parsePublicKey(sSHBuffer.readBlock());
            byte[] byArray2 = sSHBuffer.readPaddedBlock();
            if (sSHBuffer.hasRemaining()) {
                throw new IllegalArgumentException("decoded key has trailing data");
            }
            SSHBuffer sSHBuffer2 = new SSHBuffer(byArray2);
            int n3 = sSHBuffer2.readU32();
            if (n3 != (n = sSHBuffer2.readU32())) {
                throw new IllegalStateException("private key check values are not the same");
            }
            String string2 = sSHBuffer2.readString();
            if ("ssh-ed25519".equals(string2)) {
                sSHBuffer2.readBlock();
                byte[] byArray3 = sSHBuffer2.readBlock();
                if (byArray3.length != 64) {
                    throw new IllegalStateException("private key value of wrong length");
                }
                asymmetricKeyParameter = new Ed25519PrivateKeyParameters(byArray3, 0);
            } else if (string2.startsWith("ecdsa")) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = SSHNamedCurves.getByName(Strings.fromByteArray(sSHBuffer2.readBlock()));
                if (aSN1ObjectIdentifier == null) {
                    throw new IllegalStateException("OID not found for: " + string2);
                }
                X9ECParameters x9ECParameters = NISTNamedCurves.getByOID(aSN1ObjectIdentifier);
                if (x9ECParameters == null) {
                    throw new IllegalStateException("Curve not found for: " + aSN1ObjectIdentifier);
                }
                sSHBuffer2.readBlock();
                byte[] byArray4 = sSHBuffer2.readBlock();
                asymmetricKeyParameter = new ECPrivateKeyParameters(new BigInteger(1, byArray4), (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
            } else if (string2.startsWith("ssh-rsa")) {
                BigInteger bigInteger = new BigInteger(1, sSHBuffer2.readBlock());
                BigInteger bigInteger2 = new BigInteger(1, sSHBuffer2.readBlock());
                BigInteger bigInteger3 = new BigInteger(1, sSHBuffer2.readBlock());
                BigInteger bigInteger4 = new BigInteger(1, sSHBuffer2.readBlock());
                BigInteger bigInteger5 = new BigInteger(1, sSHBuffer2.readBlock());
                BigInteger bigInteger6 = new BigInteger(1, sSHBuffer2.readBlock());
                BigInteger bigInteger7 = bigInteger5.subtract(BigIntegers.ONE);
                BigInteger bigInteger8 = bigInteger6.subtract(BigIntegers.ONE);
                BigInteger bigInteger9 = bigInteger3.remainder(bigInteger7);
                BigInteger bigInteger10 = bigInteger3.remainder(bigInteger8);
                asymmetricKeyParameter = new RSAPrivateCrtKeyParameters(bigInteger, bigInteger2, bigInteger3, bigInteger5, bigInteger6, bigInteger9, bigInteger10, bigInteger4);
            }
            sSHBuffer2.skipBlock();
            if (sSHBuffer2.hasRemaining()) {
                throw new IllegalArgumentException("private key block has trailing data");
            }
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        return asymmetricKeyParameter;
    }

    private static boolean allIntegers(ASN1Sequence aSN1Sequence) {
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            if (aSN1Sequence.getObjectAt(i) instanceof ASN1Integer) continue;
            return false;
        }
        return true;
    }
}

