/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.crypto.util;

import java.io.IOException;
import java.math.BigInteger;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.x9.X9ECParameters;
import net.jsign.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.jsign.bouncycastle.crypto.params.DSAParameters;
import net.jsign.bouncycastle.crypto.params.DSAPublicKeyParameters;
import net.jsign.bouncycastle.crypto.params.ECDomainParameters;
import net.jsign.bouncycastle.crypto.params.ECNamedDomainParameters;
import net.jsign.bouncycastle.crypto.params.ECPublicKeyParameters;
import net.jsign.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import net.jsign.bouncycastle.crypto.params.RSAKeyParameters;
import net.jsign.bouncycastle.crypto.util.SSHBuffer;
import net.jsign.bouncycastle.crypto.util.SSHBuilder;
import net.jsign.bouncycastle.crypto.util.SSHNamedCurves;
import net.jsign.bouncycastle.math.ec.ECCurve;

public class OpenSSHPublicKeyUtil {
    public static AsymmetricKeyParameter parsePublicKey(byte[] byArray) {
        SSHBuffer sSHBuffer = new SSHBuffer(byArray);
        return OpenSSHPublicKeyUtil.parsePublicKey(sSHBuffer);
    }

    public static byte[] encodePublicKey(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("cipherParameters was null.");
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            if (asymmetricKeyParameter.isPrivate()) {
                throw new IllegalArgumentException("RSAKeyParamaters was for encryption");
            }
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            SSHBuilder sSHBuilder = new SSHBuilder();
            sSHBuilder.writeString("ssh-rsa");
            sSHBuilder.writeBigNum(rSAKeyParameters.getExponent());
            sSHBuilder.writeBigNum(rSAKeyParameters.getModulus());
            return sSHBuilder.getBytes();
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            SSHBuilder sSHBuilder = new SSHBuilder();
            String string = SSHNamedCurves.getNameForParameters(((ECPublicKeyParameters)asymmetricKeyParameter).getParameters());
            if (string == null) {
                throw new IllegalArgumentException("unable to derive ssh curve name for " + ((ECPublicKeyParameters)asymmetricKeyParameter).getParameters().getCurve().getClass().getName());
            }
            sSHBuilder.writeString("ecdsa-sha2-" + string);
            sSHBuilder.writeString(string);
            sSHBuilder.writeBlock(((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(false));
            return sSHBuilder.getBytes();
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            SSHBuilder sSHBuilder = new SSHBuilder();
            sSHBuilder.writeString("ssh-dss");
            sSHBuilder.writeBigNum(dSAParameters.getP());
            sSHBuilder.writeBigNum(dSAParameters.getQ());
            sSHBuilder.writeBigNum(dSAParameters.getG());
            sSHBuilder.writeBigNum(dSAPublicKeyParameters.getY());
            return sSHBuilder.getBytes();
        }
        if (asymmetricKeyParameter instanceof Ed25519PublicKeyParameters) {
            SSHBuilder sSHBuilder = new SSHBuilder();
            sSHBuilder.writeString("ssh-ed25519");
            sSHBuilder.writeBlock(((Ed25519PublicKeyParameters)asymmetricKeyParameter).getEncoded());
            return sSHBuilder.getBytes();
        }
        throw new IllegalArgumentException("unable to convert " + asymmetricKeyParameter.getClass().getName() + " to public key");
    }

    public static AsymmetricKeyParameter parsePublicKey(SSHBuffer sSHBuffer) {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        String string = sSHBuffer.readString();
        if ("ssh-rsa".equals(string)) {
            BigInteger bigInteger = sSHBuffer.readBigNumPositive();
            BigInteger bigInteger2 = sSHBuffer.readBigNumPositive();
            asymmetricKeyParameter = new RSAKeyParameters(false, bigInteger2, bigInteger);
        } else if ("ssh-dss".equals(string)) {
            BigInteger bigInteger = sSHBuffer.readBigNumPositive();
            BigInteger bigInteger3 = sSHBuffer.readBigNumPositive();
            BigInteger bigInteger4 = sSHBuffer.readBigNumPositive();
            BigInteger bigInteger5 = sSHBuffer.readBigNumPositive();
            asymmetricKeyParameter = new DSAPublicKeyParameters(bigInteger5, new DSAParameters(bigInteger, bigInteger3, bigInteger4));
        } else if (string.startsWith("ecdsa")) {
            String string2 = sSHBuffer.readString();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = SSHNamedCurves.getByName(string2);
            X9ECParameters x9ECParameters = SSHNamedCurves.getParameters(aSN1ObjectIdentifier);
            if (x9ECParameters == null) {
                throw new IllegalStateException("unable to find curve for " + string + " using curve name " + string2);
            }
            ECCurve eCCurve = x9ECParameters.getCurve();
            byte[] byArray = sSHBuffer.readBlock();
            asymmetricKeyParameter = new ECPublicKeyParameters(eCCurve.decodePoint(byArray), (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
        } else if (string.equals("sk-ecdsa-sha2-nistp256@openssh.com")) {
            String string3 = sSHBuffer.readString();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = SSHNamedCurves.getByName(string3);
            X9ECParameters x9ECParameters = SSHNamedCurves.getParameters(aSN1ObjectIdentifier);
            if (x9ECParameters == null) {
                throw new IllegalStateException("unable to find curve for " + string + " using curve name " + string3);
            }
            ECCurve eCCurve = x9ECParameters.getCurve();
            byte[] byArray = sSHBuffer.readBlock();
            String string4 = sSHBuffer.readString();
            asymmetricKeyParameter = new ECPublicKeyParameters(eCCurve.decodePoint(byArray), (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
        } else if ("ssh-ed25519".equals(string)) {
            byte[] byArray = sSHBuffer.readBlock();
            if (byArray.length != 32) {
                throw new IllegalStateException("public key value of wrong length");
            }
            asymmetricKeyParameter = new Ed25519PublicKeyParameters(byArray, 0);
        } else if ("sk-ecdsa-sha2-nistp256@openssh.com".equals(string)) {
            byte[] byArray = sSHBuffer.readBlock();
            if (byArray.length != 32) {
                throw new IllegalStateException("public key value of wrong length");
            }
            String string5 = sSHBuffer.readString();
            asymmetricKeyParameter = new Ed25519PublicKeyParameters(byArray, 0);
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        if (sSHBuffer.hasRemaining()) {
            throw new IllegalArgumentException("decoded key has trailing data");
        }
        return asymmetricKeyParameter;
    }
}

