/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.math.ec;

import java.math.BigInteger;
import net.jsign.bouncycastle.math.ec.ECConstants;
import net.jsign.bouncycastle.math.ec.ECCurve;
import net.jsign.bouncycastle.math.ec.ECFieldElement;
import net.jsign.bouncycastle.math.ec.ECPoint;
import net.jsign.bouncycastle.math.field.FiniteField;
import net.jsign.bouncycastle.math.field.PolynomialExtensionField;

public class ECAlgorithms {
    public static boolean isF2mCurve(ECCurve eCCurve) {
        return ECAlgorithms.isF2mField(eCCurve.getField());
    }

    public static boolean isF2mField(FiniteField finiteField) {
        return finiteField.getDimension() > 1 && finiteField.getCharacteristic().equals(ECConstants.TWO) && finiteField instanceof PolynomialExtensionField;
    }

    public static boolean isFpCurve(ECCurve eCCurve) {
        return ECAlgorithms.isFpField(eCCurve.getField());
    }

    public static boolean isFpField(FiniteField finiteField) {
        return finiteField.getDimension() == 1;
    }

    public static ECPoint importPoint(ECCurve eCCurve, ECPoint eCPoint) {
        ECCurve eCCurve2 = eCPoint.getCurve();
        if (!eCCurve.equals(eCCurve2)) {
            throw new IllegalArgumentException("Point must be on the same curve");
        }
        return eCCurve.importPoint(eCPoint);
    }

    public static void montgomeryTrick(ECFieldElement[] eCFieldElementArray, int n, int n2, ECFieldElement eCFieldElement) {
        ECFieldElement[] eCFieldElementArray2 = new ECFieldElement[n2];
        eCFieldElementArray2[0] = eCFieldElementArray[n];
        int n3 = 0;
        while (++n3 < n2) {
            eCFieldElementArray2[n3] = eCFieldElementArray2[n3 - 1].multiply(eCFieldElementArray[n + n3]);
        }
        --n3;
        if (eCFieldElement != null) {
            eCFieldElementArray2[n3] = eCFieldElementArray2[n3].multiply(eCFieldElement);
        }
        ECFieldElement eCFieldElement2 = eCFieldElementArray2[n3].invert();
        while (n3 > 0) {
            int n4 = n + n3--;
            ECFieldElement eCFieldElement3 = eCFieldElementArray[n4];
            eCFieldElementArray[n4] = eCFieldElementArray2[n3].multiply(eCFieldElement2);
            eCFieldElement2 = eCFieldElement2.multiply(eCFieldElement3);
        }
        eCFieldElementArray[n] = eCFieldElement2;
    }

    public static ECPoint referenceMultiply(ECPoint eCPoint, BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.abs();
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        int n = bigInteger2.bitLength();
        if (n > 0) {
            if (bigInteger2.testBit(0)) {
                eCPoint2 = eCPoint;
            }
            for (int i = 1; i < n; ++i) {
                eCPoint = eCPoint.twice();
                if (!bigInteger2.testBit(i)) continue;
                eCPoint2 = eCPoint2.add(eCPoint);
            }
        }
        return bigInteger.signum() < 0 ? eCPoint2.negate() : eCPoint2;
    }

    static ECPoint implCheckResult(ECPoint eCPoint) {
        if (!eCPoint.isValidPartial()) {
            throw new IllegalStateException("Invalid result");
        }
        return eCPoint;
    }
}

