/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.pkcs;

import java.io.IOException;
import java.util.Enumeration;
import net.jsign.bouncycastle.asn1.ASN1BitString;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.ASN1Set;
import net.jsign.bouncycastle.asn1.pkcs.Attribute;
import net.jsign.bouncycastle.asn1.pkcs.CertificationRequest;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.Extension;
import net.jsign.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.jsign.bouncycastle.pkcs.PKCSIOException;

public class PKCS10CertificationRequest {
    private static Attribute[] EMPTY_ARRAY = new Attribute[0];
    private final CertificationRequest certificationRequest;
    private final boolean isAltRequest;
    private final AlgorithmIdentifier altSignature;
    private final SubjectPublicKeyInfo altPublicKey;
    private final ASN1BitString altSignatureValue;

    private static CertificationRequest parseBytes(byte[] byArray) throws IOException {
        try {
            CertificationRequest certificationRequest = CertificationRequest.getInstance(ASN1Primitive.fromByteArray(byArray));
            if (certificationRequest == null) {
                throw new PKCSIOException("empty data passed to constructor");
            }
            return certificationRequest;
        }
        catch (ClassCastException classCastException) {
            throw new PKCSIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PKCSIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    private static ASN1Encodable getSingleValue(Attribute attribute) {
        ASN1Encodable[] aSN1EncodableArray = attribute.getAttributeValues();
        if (aSN1EncodableArray.length != 1) {
            throw new IllegalArgumentException("single value attribute value not size of 1");
        }
        return aSN1EncodableArray[0];
    }

    public PKCS10CertificationRequest(CertificationRequest certificationRequest) {
        if (certificationRequest == null) {
            throw new NullPointerException("certificationRequest cannot be null");
        }
        this.certificationRequest = certificationRequest;
        ASN1Set aSN1Set = certificationRequest.getCertificationRequestInfo().getAttributes();
        AlgorithmIdentifier algorithmIdentifier = null;
        SubjectPublicKeyInfo subjectPublicKeyInfo = null;
        ASN1BitString aSN1BitString = null;
        if (aSN1Set != null) {
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = Attribute.getInstance(enumeration.nextElement());
                if (Extension.altSignatureAlgorithm.equals(attribute.getAttrType())) {
                    algorithmIdentifier = AlgorithmIdentifier.getInstance(PKCS10CertificationRequest.getSingleValue(attribute));
                }
                if (Extension.subjectAltPublicKeyInfo.equals(attribute.getAttrType())) {
                    subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(PKCS10CertificationRequest.getSingleValue(attribute));
                }
                if (!Extension.altSignatureValue.equals(attribute.getAttrType())) continue;
                aSN1BitString = ASN1BitString.getInstance(PKCS10CertificationRequest.getSingleValue(attribute));
            }
        }
        this.isAltRequest = algorithmIdentifier != null | subjectPublicKeyInfo != null | aSN1BitString != null;
        if (this.isAltRequest && !(algorithmIdentifier != null & subjectPublicKeyInfo != null & aSN1BitString != null)) {
            throw new IllegalArgumentException("invalid alternate public key details found");
        }
        this.altSignature = algorithmIdentifier;
        this.altPublicKey = subjectPublicKeyInfo;
        this.altSignatureValue = aSN1BitString;
    }

    public PKCS10CertificationRequest(byte[] byArray) throws IOException {
        this(PKCS10CertificationRequest.parseBytes(byArray));
    }

    public CertificationRequest toASN1Structure() {
        return this.certificationRequest;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PKCS10CertificationRequest)) {
            return false;
        }
        PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)object;
        return this.toASN1Structure().equals(pKCS10CertificationRequest.toASN1Structure());
    }

    public int hashCode() {
        return this.toASN1Structure().hashCode();
    }
}

