/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.util;

import java.util.NoSuchElementException;

public final class Arrays {
    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        return java.util.Arrays.equals(byArray, byArray2);
    }

    public static boolean areEqual(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n2 - n;
        int n6 = n4 - n3;
        if (n5 != n6) {
            return false;
        }
        for (int i = 0; i < n5; ++i) {
            if (byArray[n + i] == byArray2[n3 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(char[] cArray, char[] cArray2) {
        return java.util.Arrays.equals(cArray, cArray2);
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        return java.util.Arrays.equals(nArray, nArray2);
    }

    public static boolean constantTimeAreEqual(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray == byArray2) {
            return true;
        }
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n3 = byArray.length ^ byArray2.length;
        for (n = 0; n != n2; ++n) {
            n3 |= byArray[n] ^ byArray2[n];
        }
        for (n = n2; n < byArray2.length; ++n) {
            n3 |= byArray2[n] ^ ~byArray2[n];
        }
        return n3 == 0;
    }

    public static boolean constantTimeAreEqual(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (null == byArray) {
            throw new NullPointerException("'a' cannot be null");
        }
        if (null == byArray2) {
            throw new NullPointerException("'b' cannot be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("'len' cannot be negative");
        }
        if (n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("'aOff' value invalid for specified length");
        }
        if (n3 > byArray2.length - n) {
            throw new IndexOutOfBoundsException("'bOff' value invalid for specified length");
        }
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 |= byArray[n2 + i] ^ byArray2[n3 + i];
        }
        return 0 == n4;
    }

    public static void fill(byte[] byArray, byte by) {
        java.util.Arrays.fill(byArray, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        java.util.Arrays.fill(byArray, n, n2, by);
    }

    public static void fill(char[] cArray, char c) {
        java.util.Arrays.fill(cArray, c);
    }

    public static void fill(long[] lArray, long l) {
        java.util.Arrays.fill(lArray, l);
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = byArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= byArray[n];
        }
        return n2;
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return 0;
        }
        int n3 = n2;
        int n4 = n3 + 1;
        while (--n3 >= 0) {
            n4 *= 257;
            n4 ^= byArray[n + n3];
        }
        return n4;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = cArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= cArray[n];
        }
        return n2;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = nArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= nArray[n];
        }
        return n2;
    }

    public static int hashCode(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return 0;
        }
        int n3 = n2;
        int n4 = n3 + 1;
        while (--n3 >= 0) {
            n4 *= 257;
            n4 ^= nArray[n + n3];
        }
        return n4;
    }

    public static int hashCode(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return 0;
        }
        int n3 = n2;
        int n4 = n3 + 1;
        while (--n3 >= 0) {
            long l = lArray[n + n3];
            n4 *= 257;
            n4 ^= (int)l;
            n4 *= 257;
            n4 ^= (int)(l >>> 32);
        }
        return n4;
    }

    public static byte[] clone(byte[] byArray) {
        return null == byArray ? null : (byte[])byArray.clone();
    }

    public static char[] clone(char[] cArray) {
        return null == cArray ? null : (char[])cArray.clone();
    }

    public static int[] clone(int[] nArray) {
        return null == nArray ? null : (int[])nArray.clone();
    }

    public static long[] clone(long[] lArray) {
        return null == lArray ? null : (long[])lArray.clone();
    }

    public static short[] clone(short[] sArray) {
        return null == sArray ? null : (short[])sArray.clone();
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        int n3 = Arrays.getLength(n, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
        return byArray2;
    }

    private static int getLength(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        return n3;
    }

    public static byte[] append(byte[] byArray, byte by) {
        if (byArray == null) {
            return new byte[]{by};
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        if (null == byArray) {
            return Arrays.clone(byArray2);
        }
        if (null == byArray2) {
            return Arrays.clone(byArray);
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static short[] concatenate(short[] sArray, short[] sArray2) {
        if (null == sArray) {
            return Arrays.clone(sArray2);
        }
        if (null == sArray2) {
            return Arrays.clone(sArray);
        }
        short[] sArray3 = new short[sArray.length + sArray2.length];
        System.arraycopy(sArray, 0, sArray3, 0, sArray.length);
        System.arraycopy(sArray2, 0, sArray3, sArray.length, sArray2.length);
        return sArray3;
    }

    public static byte[] prepend(byte[] byArray, byte by) {
        if (byArray == null) {
            return new byte[]{by};
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 1, n);
        byArray2[0] = by;
        return byArray2;
    }

    public static void reverse(byte[] byArray, byte[] byArray2) {
        int n = byArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            byArray2[i] = byArray[n - i];
        }
    }

    public static byte[] reverseInPlace(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        int n = 0;
        int n2 = byArray.length - 1;
        while (n < n2) {
            byte by = byArray[n];
            byte by2 = byArray[n2];
            byArray[n++] = by2;
            byArray[n2--] = by;
        }
        return byArray;
    }

    public static short[] reverseInPlace(short[] sArray) {
        if (null == sArray) {
            return null;
        }
        int n = 0;
        int n2 = sArray.length - 1;
        while (n < n2) {
            short s = sArray[n];
            short s2 = sArray[n2];
            sArray[n++] = s2;
            sArray[n2--] = s;
        }
        return sArray;
    }

    public static void clear(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            java.util.Arrays.fill(byArray, n, n + n2, (byte)0);
        }
    }

    public static void clear(byte[] byArray) {
        if (null != byArray) {
            java.util.Arrays.fill(byArray, (byte)0);
        }
    }

    public static void clear(int[][] nArray) {
        if (null != nArray) {
            for (int[] nArray2 : nArray) {
                java.util.Arrays.fill(nArray2, 0);
            }
        }
    }

    public static void clear(long[][] lArray) {
        if (null != lArray) {
            for (long[] lArray2 : lArray) {
                java.util.Arrays.fill(lArray2, 0L);
            }
        }
    }

    public static boolean isNullOrContainsNull(Object[] objectArray) {
        if (null == objectArray) {
            return true;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (null != objectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static class Iterator<T>
    implements java.util.Iterator<T> {
        private final T[] dataArray;
        private int position = 0;

        public Iterator(T[] TArray) {
            this.dataArray = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.dataArray.length;
        }

        @Override
        public T next() {
            if (this.position == this.dataArray.length) {
                throw new NoSuchElementException("Out of elements: " + this.position);
            }
            return this.dataArray[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from an Array.");
        }
    }
}

