/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.commons.io.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.jsign.commons.io.build.AbstractSupplier;

public abstract class AbstractOrigin<T, B extends AbstractOrigin<T, B>>
extends AbstractSupplier<T, B> {
    final T origin;

    protected AbstractOrigin(T origin) {
        this.origin = Objects.requireNonNull(origin, "origin");
    }

    public T get() {
        return this.origin;
    }

    public InputStream getInputStream(OpenOption ... options) throws IOException {
        return Files.newInputStream(this.getPath(), options);
    }

    public Path getPath() {
        throw new UnsupportedOperationException(String.format("%s#getPath() for %s origin %s", this.getSimpleClassName(), this.origin.getClass().getSimpleName(), this.origin));
    }

    private String getSimpleClassName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getSimpleClassName() + "[" + this.origin.toString() + "]";
    }

    public static class InputStreamOrigin
    extends AbstractOrigin<InputStream, InputStreamOrigin> {
        public InputStreamOrigin(InputStream origin) {
            super(origin);
        }

        @Override
        public InputStream getInputStream(OpenOption ... options) {
            return (InputStream)this.get();
        }
    }
}

