/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.commons.io.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.function.IntUnaryOperator;
import net.jsign.commons.io.build.AbstractOriginSupplier;
import net.jsign.commons.io.file.PathUtils;

public abstract class AbstractStreamBuilder<T, B extends AbstractStreamBuilder<T, B>>
extends AbstractOriginSupplier<T, B> {
    private static final OpenOption[] DEFAULT_OPEN_OPTIONS = PathUtils.EMPTY_OPEN_OPTION_ARRAY;
    private int bufferSize = 8192;
    private int bufferSizeDefault = 8192;
    private int bufferSizeMax = Integer.MAX_VALUE;
    private Charset charset = Charset.defaultCharset();
    private Charset charsetDefault = Charset.defaultCharset();
    private OpenOption[] openOptions = DEFAULT_OPEN_OPTIONS;
    private final IntUnaryOperator defaultSizeChecker;
    private IntUnaryOperator bufferSizeChecker = this.defaultSizeChecker = size -> size > this.bufferSizeMax ? this.throwIae(size, this.bufferSizeMax) : size;

    private int checkBufferSize(int size) {
        return this.bufferSizeChecker.applyAsInt(size);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public InputStream getInputStream() throws IOException {
        return this.checkOrigin().getInputStream(this.getOpenOptions());
    }

    public OpenOption[] getOpenOptions() {
        return this.openOptions;
    }

    public B setBufferSize(int bufferSize) {
        this.bufferSize = this.checkBufferSize(bufferSize > 0 ? bufferSize : this.bufferSizeDefault);
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    private int throwIae(int size, int max) {
        throw new IllegalArgumentException(String.format("Request %,d exceeds maximum %,d", size, max));
    }
}

