/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.commons.lang3;

import java.util.regex.Pattern;
import net.jsign.commons.lang3.ArrayUtils;
import net.jsign.commons.lang3.CharSequenceUtils;

public class StringUtils {
    private static final Pattern STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    public static boolean containsAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return false;
        }
        int csLength = cs.length();
        int searchLength = searchChars.length;
        int csLast = csLength - 1;
        int searchLast = searchLength - 1;
        for (int i = 0; i < csLength; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLength; ++j) {
                if (searchChars[j] != ch) continue;
                if (!Character.isHighSurrogate(ch)) {
                    return true;
                }
                if (j == searchLast) {
                    return true;
                }
                if (i >= csLast || searchChars[j + 1] != cs.charAt(i + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsNone(CharSequence cs, char ... searchChars) {
        if (cs == null || searchChars == null) {
            return true;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i = 0; i < csLen; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (!Character.isHighSurrogate(ch)) {
                    return false;
                }
                if (j == searchLast) {
                    return false;
                }
                if (i >= csLast || searchChars[j + 1] != cs.charAt(i + 1)) continue;
                return false;
            }
        }
        return true;
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(seq, searchSeq, startPos);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i = startPos; i < endLimit; ++i) {
            if (!CharSequenceUtils.regionMatches(str, true, i, searchStr, 0, searchStr.length())) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        return StringUtils.replace(text, searchString, replacement, max, false);
    }

    private static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        int end;
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        if (ignoreCase) {
            searchString = searchString.toLowerCase();
        }
        int start = 0;
        int n = end = ignoreCase ? StringUtils.indexOfIgnoreCase(text, searchString, start) : StringUtils.indexOf(text, searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = Math.max(replacement.length() - replLength, 0);
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : Math.min(max, 64)));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = ignoreCase ? StringUtils.indexOfIgnoreCase(text, searchString, start) : StringUtils.indexOf(text, searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }
}

