/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.jsign.DigestAlgorithm;
import net.jsign.bouncycastle.util.encoders.Hex;
import net.jsign.jca.AmazonCredentials;
import net.jsign.jca.JsonWriter;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

public class AmazonSigningService
implements SigningService {
    private final Function<String, Certificate[]> certificateStore;
    private final Map<String, SigningServicePrivateKey> keys = new HashMap<String, SigningServicePrivateKey>();
    private final RESTClient client;
    private final Map<String, String> algorithmMapping = new HashMap<String, String>();

    public AmazonSigningService(String region, Supplier<AmazonCredentials> credentials, Function<String, Certificate[]> certificateStore) {
        this(credentials, certificateStore, AmazonSigningService.getEndpointUrl(region));
    }

    public AmazonSigningService(String region, AmazonCredentials credentials, Function<String, Certificate[]> certificateStore) {
        this(region, () -> credentials, certificateStore);
    }

    AmazonSigningService(Supplier<AmazonCredentials> credentials, Function<String, Certificate[]> certificateStore, String endpoint) {
        this.algorithmMapping.put("SHA256withRSA", "RSASSA_PKCS1_V1_5_SHA_256");
        this.algorithmMapping.put("SHA384withRSA", "RSASSA_PKCS1_V1_5_SHA_384");
        this.algorithmMapping.put("SHA512withRSA", "RSASSA_PKCS1_V1_5_SHA_512");
        this.algorithmMapping.put("SHA256withECDSA", "ECDSA_SHA_256");
        this.algorithmMapping.put("SHA384withECDSA", "ECDSA_SHA_384");
        this.algorithmMapping.put("SHA512withECDSA", "ECDSA_SHA_512");
        this.algorithmMapping.put("SHA256withRSA/PSS", "RSASSA_PSS_SHA_256");
        this.algorithmMapping.put("SHA384withRSA/PSS", "RSASSA_PSS_SHA_384");
        this.algorithmMapping.put("SHA512withRSA/PSS", "RSASSA_PSS_SHA_512");
        this.certificateStore = certificateStore;
        this.client = new RESTClient(endpoint).authentication((conn, data) -> this.sign((HttpURLConnection)conn, (AmazonCredentials)credentials.get(), (byte[])data, null)).errorHandler(response -> response.get("__type") + ": " + response.get("message"));
    }

    @Deprecated
    public AmazonSigningService(String region, String credentials, Function<String, Certificate[]> certificateStore) {
        this(region, AmazonCredentials.parse(credentials), certificateStore);
    }

    static String getEndpointUrl(String region) {
        String domain = "true".equalsIgnoreCase(AmazonSigningService.getenv("AWS_USE_FIPS_ENDPOINT")) ? "kms-fips" : "kms";
        return "https://" + domain + "." + region + ".amazonaws.com";
    }

    @Override
    public String getName() {
        return "AWS";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            Object[] keys;
            Map<String, ?> response = this.query("TrentService.ListKeys", "{}");
            for (Object key : keys = (Object[])response.get("Keys")) {
                aliases.add((String)((Map)key).get("KeyId"));
            }
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        return aliases;
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.certificateStore.apply(alias);
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        String algorithm;
        if (this.keys.containsKey(alias)) {
            return this.keys.get(alias);
        }
        try {
            Map<String, ?> response = this.query("TrentService.DescribeKey", "{\"KeyId\":\"" + this.normalizeKeyId(alias) + "\"}");
            Map keyMetadata = (Map)response.get("KeyMetadata");
            String keyUsage = (String)keyMetadata.get("KeyUsage");
            if (!"SIGN_VERIFY".equals(keyUsage)) {
                throw new UnrecoverableKeyException("The key '" + alias + "' is not a signing key");
            }
            String keyState = (String)keyMetadata.get("KeyState");
            if (!"Enabled".equals(keyState)) {
                throw new UnrecoverableKeyException("The key '" + alias + "' is not enabled (" + keyState + ")");
            }
            String keySpec = (String)keyMetadata.get("KeySpec");
            algorithm = keySpec.substring(0, keySpec.indexOf(95));
            if ("ECC".equals(algorithm)) {
                algorithm = "EC";
            }
        }
        catch (IOException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unable to fetch AWS key '" + alias + "'").initCause(e);
        }
        SigningServicePrivateKey key = new SigningServicePrivateKey(alias, algorithm, this);
        this.keys.put(alias, key);
        return key;
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        String alg = this.algorithmMapping.get(algorithm);
        if (alg == null) {
            throw new InvalidAlgorithmParameterException("Unsupported signing algorithm: " + algorithm);
        }
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        data = digestAlgorithm.getMessageDigest().digest(data);
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("KeyId", this.normalizeKeyId(privateKey.getId()));
        request.put("MessageType", "DIGEST");
        request.put("Message", Base64.getEncoder().encodeToString(data));
        request.put("SigningAlgorithm", alg);
        try {
            Map<String, ?> response = this.query("TrentService.Sign", JsonWriter.format(request));
            String signature = (String)response.get("Signature");
            return Base64.getDecoder().decode(signature);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private Map<String, ?> query(String target, String body) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Amz-Target", target);
        headers.put("Content-Type", "application/x-amz-json-1.1");
        return this.client.post("/", body, headers);
    }

    private String normalizeKeyId(String keyId) {
        if (keyId.startsWith("arn:") || keyId.startsWith("alias/")) {
            return keyId;
        }
        if (!keyId.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")) {
            return "alias/" + keyId;
        }
        return keyId;
    }

    void sign(HttpURLConnection conn, AmazonCredentials credentials, byte[] content, Date date) {
        String host;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (date == null) {
            date = new Date();
        }
        URL endpoint = conn.getURL();
        Pattern hostnamePattern = Pattern.compile("^([^.]+)\\.([^.]+)\\.amazonaws\\.com$");
        Matcher matcher = hostnamePattern.matcher(host = endpoint.getHost());
        String regionName = matcher.matches() ? matcher.group(2) : "us-east-1";
        String serviceName = matcher.matches() ? matcher.group(1).replace("-fips", "") : "kms";
        String credentialScope = dateFormat.format(date) + "/" + regionName + "/" + serviceName + "/aws4_request";
        conn.addRequestProperty("X-Amz-Date", dateTimeFormat.format(date));
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        headers.putAll(conn.getRequestProperties());
        headers.put("Host", Collections.singletonList(host));
        String canonicalRequest = conn.getRequestMethod() + "\n" + endpoint.getPath() + (endpoint.getPath().endsWith("/") ? "" : "/") + "\n\n" + this.canonicalHeaders(headers) + "\n" + this.signedHeaders(headers) + "\n" + this.sha256(content);
        String stringToSign = "AWS4-HMAC-SHA256\n" + dateTimeFormat.format(date) + "\n" + credentialScope + "\n" + this.sha256(canonicalRequest.getBytes(StandardCharsets.UTF_8));
        byte[] key = ("AWS4" + credentials.getSecretKey()).getBytes(StandardCharsets.UTF_8);
        byte[] signingKey = this.hmac("aws4_request", this.hmac(serviceName, this.hmac(regionName, this.hmac(dateFormat.format(date), key))));
        byte[] signature = this.hmac(stringToSign, signingKey);
        conn.setRequestProperty("Authorization", "AWS4-HMAC-SHA256 Credential=" + credentials.getAccessKey() + "/" + credentialScope + ", SignedHeaders=" + this.signedHeaders(headers) + ", Signature=" + Hex.toHexString(signature).toLowerCase());
        if (credentials.getSessionToken() != null) {
            conn.setRequestProperty("X-Amz-Security-Token", credentials.getSessionToken());
        }
    }

    private String canonicalHeaders(Map<String, List<String>> headers) {
        return headers.entrySet().stream().map(entry -> ((String)entry.getKey()).toLowerCase() + ":" + String.join((CharSequence)",", (Iterable)entry.getValue()).replaceAll("\\s+", " ")).collect(Collectors.joining("\n")) + "\n";
    }

    private String signedHeaders(Map<String, List<String>> headers) {
        return headers.keySet().stream().map(String::toLowerCase).collect(Collectors.joining(";"));
    }

    private byte[] hmac(String data, byte[] key) {
        return this.hmac(data.getBytes(StandardCharsets.UTF_8), key);
    }

    private byte[] hmac(byte[] data, byte[] key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, mac.getAlgorithm()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String sha256(byte[] data) {
        MessageDigest digest = DigestAlgorithm.SHA256.getMessageDigest();
        digest.update(data);
        return Hex.toHexString(digest.digest()).toLowerCase();
    }

    static String getenv(String name) {
        return System.getenv(name);
    }
}

