/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.GaraSignCredentials;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

public class GaraSignSigningService
implements SigningService {
    private final Map<String, Map<String, ?>> certificates = new LinkedHashMap();
    private final String endpoint;
    private final RESTClient client;
    private final GaraSignCredentials credentials;
    private long timeout = 3600L;

    public GaraSignSigningService(String endpoint, GaraSignCredentials credentials) {
        this.endpoint = endpoint != null ? endpoint : "https://garasign.com:8443/CodeSigningRestService/";
        this.credentials = credentials;
        this.client = new RESTClient(endpoint);
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getName() {
        return "GaraSign";
    }

    private void loadKeyStore() throws KeyStoreException {
        if (this.certificates.isEmpty()) {
            try {
                Object[] keys;
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put("api_version", "1.0");
                params.put("session_token", this.credentials.getSessionToken(this.endpoint));
                Map<String, ?> response = this.client.post("/keystore", params);
                String status = (String)response.get("status");
                if (!"SUCCESS".equals(status)) {
                    throw new KeyStoreException("Unable to retrieve the GaraSign keystore: " + response.get("message"));
                }
                for (Object key : keys = (Object[])response.get("keys")) {
                    String name = (String)((Map)key).get("name");
                    this.certificates.put(name, (Map)key);
                }
            }
            catch (IOException e) {
                throw new KeyStoreException("Unable to retrieve the GaraSign keystore", e);
            }
        }
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        this.loadKeyStore();
        return new ArrayList<String>(this.certificates.keySet());
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        this.loadKeyStore();
        Map<String, ?> key = this.certificates.get(alias);
        if (key == null) {
            throw new KeyStoreException("Unable to retrieve GaraSign certificate '" + alias + "'");
        }
        Object[] certChain = (Object[])key.get("certChain");
        Certificate[] chain = new Certificate[certChain.length];
        for (int i = 0; i < certChain.length; ++i) {
            byte[] data = this.decode((Object[])certChain[i]);
            try {
                chain[i] = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(data));
                continue;
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
        }
        return chain;
    }

    private String getAlgorithm(String alias) throws KeyStoreException {
        this.loadKeyStore();
        Map<String, ?> key = this.certificates.get(alias);
        if (key == null) {
            return null;
        }
        return (String)key.get("algorithm");
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        try {
            String algorithm = this.getAlgorithm(alias);
            if (algorithm == null) {
                throw new UnrecoverableKeyException("Unable to fetch GaraSign private key for the certificate '" + alias + "'");
            }
            return new SigningServicePrivateKey(alias, algorithm, this);
        }
        catch (KeyStoreException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException().initCause(e);
        }
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        data = digestAlgorithm.getMessageDigest().digest(data);
        try {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("api_version", "1.0");
            params.put("session_token", this.credentials.getSessionToken(this.endpoint));
            params.put("key_name", privateKey.getId());
            params.put("signature_scheme", algorithm);
            params.put("data_to_sign", Base64.getEncoder().encodeToString(data));
            Map<String, ?> response = this.client.post("/sign", params);
            String status = (String)response.get("status");
            if ("FAILURE".equals(status)) {
                throw new IOException("Signing operation failed: " + response.get("message"));
            }
            String requestId = (String)response.get("requestId");
            params.put("request_id", requestId);
            params.remove("key_name");
            params.remove("signature_scheme");
            params.remove("data_to_sign");
            String message = null;
            if ("IN_PROGRESS".equals(status)) {
                long startTime = System.currentTimeMillis();
                int i = 0;
                while (System.currentTimeMillis() - startTime < this.timeout * 1000L) {
                    try {
                        Thread.sleep(Math.min(1000, 100 + 100 * i++));
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    response = this.client.post("/sign", params);
                    status = (String)response.get("status");
                    if ("IN_PROGRESS".equals(status)) {
                        if (System.currentTimeMillis() - startTime <= 3000L || response.get("message") == null || response.get("message").equals(message)) continue;
                        message = (String)response.get("message");
                        continue;
                    }
                    if ("SUCCESS".equals(status)) break;
                    throw new IOException("Signing operation " + requestId + " failed: " + response.get("message"));
                }
            }
            if (!"SUCCESS".equals(response.get("status"))) {
                throw new IOException("Signing operation " + requestId + " timed out");
            }
            return this.decode((Object[])response.get("signature"));
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private byte[] decode(Object[] array) {
        byte[] data = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            data[i] = ((Number)array[i]).byteValue();
        }
        return data;
    }
}

