/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.JsonWriter;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

public class HashiCorpVaultSigningService
implements SigningService {
    private final Function<String, Certificate[]> certificateStore;
    private final Map<String, SigningServicePrivateKey> keys = new HashMap<String, SigningServicePrivateKey>();
    private final RESTClient client;
    private VaultEngine engine;

    public HashiCorpVaultSigningService(String engineURL, String token, Function<String, Certificate[]> certificateStore) {
        this.certificateStore = certificateStore;
        this.client = new RESTClient(engineURL.endsWith("/") ? engineURL : engineURL + "/").authentication(conn -> conn.setRequestProperty("Authorization", "Bearer " + token));
    }

    @Override
    public String getName() {
        return "HashiCorpVault";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            Object[] keys;
            Map<String, ?> response = this.client.get("keys?list=true");
            for (Object key : keys = (Object[])((Map)response.get("data")).get("keys")) {
                aliases.add((String)key);
            }
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        return aliases;
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.certificateStore.apply(alias);
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        String algorithm;
        block6: {
            if (this.keys.containsKey(alias)) {
                return this.keys.get(alias);
            }
            if (!alias.contains(":")) {
                throw new UnrecoverableKeyException("Unable to fetch HashiCorp Vault private key '" + alias + "' (missing key version)");
            }
            try {
                Map<String, ?> response = this.client.get("keys/" + alias.substring(0, alias.indexOf(":")));
                Map data = (Map)response.get("data");
                if (data.containsKey("algorithm")) {
                    this.engine = VaultEngine.GCPKMS;
                    algorithm = (String)data.get("algorithm");
                    algorithm = algorithm.substring(0, algorithm.indexOf("_")).toUpperCase();
                    break block6;
                }
                if (data.containsKey("type")) {
                    this.engine = VaultEngine.TRANSIT;
                    algorithm = (String)data.get("type");
                    algorithm = algorithm.substring(0, algorithm.indexOf("-")).toUpperCase();
                    break block6;
                }
                throw new UnrecoverableKeyException("Unsupported secret engine");
            }
            catch (IOException e) {
                throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unable to fetch HashiCorp Vault private key '" + alias + "'").initCause(e);
            }
        }
        SigningServicePrivateKey key = new SigningServicePrivateKey(alias, algorithm, this);
        this.keys.put(alias, key);
        return key;
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        data = digestAlgorithm.getMessageDigest().digest(data);
        String alias = privateKey.getId();
        String keyName = alias.substring(0, alias.indexOf(":"));
        String keyVersion = alias.substring(alias.indexOf(":") + 1);
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("key_version", keyVersion);
        if (this.engine == VaultEngine.GCPKMS) {
            request.put("digest", Base64.getEncoder().encodeToString(data));
        } else {
            request.put("input", Base64.getEncoder().encodeToString(data));
            request.put("prehashed", true);
            request.put("hash_algorithm", this.getHashAlgorithm(digestAlgorithm));
            if ("RSA".equals(privateKey.getAlgorithm())) {
                request.put("signature_algorithm", "pkcs1v15");
            }
        }
        try {
            String signature;
            Map<String, ?> response = this.client.post("sign/" + keyName, JsonWriter.format(request));
            Map response_data = (Map)response.get("data");
            if (this.engine == VaultEngine.GCPKMS) {
                signature = (String)response_data.get("signature");
            } else {
                String[] fields = ((String)response_data.get("signature")).split(":");
                signature = fields[2];
            }
            return Base64.getDecoder().decode(signature);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private String getHashAlgorithm(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA1: {
                return "sha1";
            }
            case SHA256: {
                return "sha2-256";
            }
            case SHA384: {
                return "sha2-384";
            }
            case SHA512: {
                return "sha2-512";
            }
        }
        throw new IllegalArgumentException("Unsupported digest algorithm: " + (Object)((Object)digestAlgorithm));
    }

    private static enum VaultEngine {
        GCPKMS,
        TRANSIT;

    }
}

