/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import net.jsign.DigestAlgorithm;
import net.jsign.KeyStoreBuilder;
import net.jsign.KeyStoreType;
import net.jsign.jca.AbstractKeyStoreSpi;
import net.jsign.jca.AbstractSignatureSpi;
import net.jsign.jca.ProviderService;

public class JsignJcaProvider
extends Provider {
    private String keystore;

    public JsignJcaProvider() {
        super("Jsign", 1.0, "Jsign security provider");
        AccessController.doPrivileged(() -> {
            for (KeyStoreType keyStoreType : KeyStoreType.values()) {
                this.putService(new ProviderService(this, "KeyStore", keyStoreType.name(), JsignJcaKeyStore.class.getName(), () -> new JsignJcaKeyStore(type, this.keystore)));
            }
            for (String string : new String[]{"RSA", "ECDSA"}) {
                for (DigestAlgorithm digest : DigestAlgorithm.values()) {
                    if (digest == DigestAlgorithm.MD5) continue;
                    String algorithm = digest.name() + "with" + string;
                    this.putService(new ProviderService(this, "Signature", algorithm, JsignJcaSignature.class.getName(), () -> new JsignJcaSignature(algorithm)));
                }
            }
            return null;
        });
    }

    public JsignJcaProvider(String configArg) {
        this();
        this.configure(configArg);
    }

    @Override
    public Provider configure(String configArg) throws InvalidParameterException {
        this.keystore = configArg;
        return this;
    }

    static class JsignJcaSignature
    extends AbstractSignatureSpi {
        private Signature signature;

        public JsignJcaSignature(String signingAlgorithm) {
            super(signingAlgorithm);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            JsignJcaPrivateKey key = (JsignJcaPrivateKey)privateKey;
            try {
                this.signature = Signature.getInstance(this.signingAlgorithm, key.getProvider());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            this.signature.initSign(key.getPrivateKey());
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            this.signature.update(b);
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            this.signature.update(b, off, len);
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            return this.signature.sign();
        }
    }

    static class JsignJcaPrivateKey
    implements PrivateKey {
        private final PrivateKey privateKey;
        private final Provider provider;

        public JsignJcaPrivateKey(PrivateKey key, Provider provider) {
            this.privateKey = key;
            this.provider = provider;
        }

        @Override
        public String getAlgorithm() {
            return this.privateKey.getAlgorithm();
        }

        @Override
        public String getFormat() {
            return this.privateKey.getFormat();
        }

        @Override
        public byte[] getEncoded() {
            return this.privateKey.getEncoded();
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public Provider getProvider() {
            return this.provider;
        }
    }

    static class JsignJcaKeyStore
    extends AbstractKeyStoreSpi {
        private KeyStoreBuilder builder = new KeyStoreBuilder();
        private KeyStore keystore;

        public JsignJcaKeyStore(KeyStoreType type, String keystore) {
            this.builder.storetype(type);
            this.builder.keystore(keystore);
            this.builder.certfile("");
        }

        private KeyStore getKeyStore() throws KeyStoreException {
            if (this.keystore == null) {
                this.keystore = this.builder.build();
            }
            return this.keystore;
        }

        @Override
        public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
            if (password != null) {
                this.builder.keypass(new String(password));
            }
            try {
                return new JsignJcaPrivateKey((PrivateKey)this.getKeyStore().getKey(alias, password), this.builder.provider());
            }
            catch (UnrecoverableKeyException e) {
                e.printStackTrace();
                throw e;
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Certificate[] engineGetCertificateChain(String alias) {
            try {
                return this.getKeyStore().getCertificateChain(alias);
            }
            catch (KeyStoreException e) {
                return null;
            }
        }

        @Override
        public Enumeration<String> engineAliases() {
            try {
                return this.getKeyStore().aliases();
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void engineLoad(InputStream stream, char[] password) {
            if (password != null) {
                this.builder.storepass(new String(password));
            }
        }
    }
}

