/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

class JsonWriter {
    public static String format(Object object) {
        StringBuilder out = new StringBuilder();
        JsonWriter.format(object, out);
        return out.toString();
    }

    public static void format(Object value, StringBuilder out) {
        if (value instanceof String) {
            String s = (String)value;
            out.append("\"");
            out.append(s.replace("\\", "\\\\").replace("\"", "\\\""));
            out.append("\"");
        } else if (value instanceof Number || value instanceof Boolean) {
            out.append(value);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            out.append("{");
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                JsonWriter.format(entry.getKey(), out);
                out.append(":");
                JsonWriter.format(entry.getValue(), out);
                if (!iterator.hasNext()) continue;
                out.append(',');
            }
            out.append("}");
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            out.append("[");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JsonWriter.format(iterator.next(), out);
                if (!iterator.hasNext()) continue;
                out.append(',');
            }
            out.append("]");
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            out.append("[");
            Iterator iterator = Stream.of(array).iterator();
            while (iterator.hasNext()) {
                JsonWriter.format(iterator.next(), out);
                if (!iterator.hasNext()) continue;
                out.append(',');
            }
            out.append("]");
        } else if (value == null) {
            out.append("null");
        } else {
            throw new RuntimeException("Unsupported type: " + value.getClass().getSimpleName());
        }
    }
}

