/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import net.jsign.jca.SmartCard;
import net.jsign.jca.TLV;

class PIVCard
extends SmartCard {
    private PIVCard(CardChannel channel) throws CardException {
        super(channel);
        this.select();
    }

    private void select() throws CardException {
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 164, 4, 0, new byte[]{-96, 0, 0, 3, 8, 0, 0, 16, 0}));
        switch (response.getSW()) {
            case 27266: 
            case 27270: {
                throw new CardException("PIV application not found on the card/token");
            }
        }
        this.handleError(response);
    }

    public void verify(int p1, int p2, String pin) throws CardException {
        if (pin == null) {
            pin = "";
        }
        byte[] mask = new byte[8];
        Arrays.fill(mask, (byte)-1);
        System.arraycopy(pin.getBytes(), 0, mask, 0, pin.length());
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 32, p1, p2, mask));
        this.handleError(response);
    }

    public byte[] getData(int tag) throws CardException {
        byte[] data;
        if (this.dataObjectCache.containsKey(tag)) {
            return (byte[])this.dataObjectCache.get(tag);
        }
        if (tag < 256) {
            data = new byte[]{92, 1, (byte)(tag & 0xFF)};
        } else if (tag < 65536) {
            data = new byte[]{92, 2, (byte)((tag & 0xFF00) >> 8), (byte)(tag & 0xFF)};
        } else if (tag < 0x1000000) {
            data = new byte[]{92, 3, (byte)((tag & 0xFF0000) >> 16), (byte)((tag & 0xFF00) >> 8), (byte)(tag & 0xFF)};
        } else {
            throw new CardException("Invalid tag 0x" + Integer.toHexString(tag).toUpperCase());
        }
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 203, 63, 255, data));
        if (response.getSW() == 27272) {
            throw new CardException("Data object 0x" + Integer.toHexString(tag).toUpperCase() + " not found");
        }
        this.handleError(response);
        this.dataObjectCache.put(tag, response.getData());
        return response.getData();
    }

    public Set<Key> getAvailableKeys() throws CardException {
        LinkedHashSet<Key> keys = new LinkedHashSet<Key>();
        for (Key key : Key.values()) {
            if (this.getCertificate(key) == null) continue;
            keys.add(key);
        }
        return keys;
    }

    public Certificate getCertificate(Key key) throws CardException {
        byte[] data;
        try {
            data = this.getData(key.tag);
        }
        catch (CardException e) {
            if ("Incorrect P1 or P2 parameter".equals(e.getMessage())) {
                return null;
            }
            throw e;
        }
        TLV tlv = TLV.parse(ByteBuffer.wrap(data));
        tlv = TLV.parse(ByteBuffer.wrap(tlv.value()), false);
        boolean compressed = false;
        TLV compressionField = tlv.find("71");
        if (compressionField != null) {
            compressed = compressionField.value()[0] == 1;
        }
        try {
            TLV certificateField = tlv.find("70");
            InputStream in = new ByteArrayInputStream(certificateField.value());
            if (compressed) {
                in = new GZIPInputStream(in);
            }
            return CertificateFactory.getInstance("X.509").generateCertificate(in);
        }
        catch (IOException | CertificateException e) {
            throw new CardException("Invalid certificate for " + key.name() + " key", e);
        }
    }

    public KeyInfo getKeyInfo(Key key) throws CardException {
        Certificate certificate = this.getCertificate(key);
        if (certificate == null) {
            throw new CardException(key.name() + " key not found");
        }
        PublicKey publicKey = certificate.getPublicKey();
        KeyInfo info = new KeyInfo();
        info.algorithm = publicKey.getAlgorithm();
        if ("RSA".equals(info.algorithm)) {
            info.size = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
            switch (info.size) {
                case 1024: {
                    info.algorithmId = 6;
                    break;
                }
                case 2048: {
                    info.algorithmId = 7;
                    break;
                }
                case 3072: {
                    info.algorithmId = 5;
                    break;
                }
                case 4096: {
                    info.algorithmId = 22;
                }
            }
        } else if ("EC".equals(info.algorithm)) {
            ECParameterSpec spec = ((ECKey)((Object)publicKey)).getParams();
            if (spec != null) {
                info.size = spec.getOrder().bitLength();
            }
            switch (info.size) {
                case 256: {
                    info.algorithmId = 17;
                    break;
                }
                case 384: {
                    info.algorithmId = 20;
                }
            }
        }
        return info;
    }

    public byte[] sign(Key key, byte[] data) throws CardException {
        KeyInfo info = this.getKeyInfo(key);
        if ("RSA".equalsIgnoreCase(info.algorithm)) {
            data = this.rsaPadding(data, info.size);
        }
        if (this.pin != null) {
            this.verify(0, 128, this.pin);
        }
        TLV template = new TLV("7C");
        template.children().add(new TLV("82", new byte[0]));
        template.children().add(new TLV("81", data));
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 135, info.algorithmId, key.slot, template.getEncoded()));
        this.handleError(response);
        TLV tlv = TLV.parse(ByteBuffer.wrap(response.getData()), true);
        return tlv.find("82").value();
    }

    private byte[] rsaPadding(byte[] message, int keyLength) {
        byte[] padded = new byte[keyLength / 8];
        Arrays.fill(padded, (byte)-1);
        padded[0] = 0;
        padded[1] = 1;
        System.arraycopy(message, 0, padded, padded.length - message.length, message.length);
        padded[padded.length - message.length - 1] = 0;
        return padded;
    }

    public static PIVCard getCard(String name) throws CardException {
        CardChannel channel = PIVCard.openChannel(name);
        return channel != null ? new PIVCard(channel) : null;
    }

    public static class KeyInfo {
        public String algorithm;
        public int algorithmId;
        public int size;
    }

    public static enum Key {
        AUTHENTICATION(154, 6275333, "X.509 Certificate for PIV Authentication"),
        SIGNATURE(156, 6275338, "X.509 Certificate for Digital Signature"),
        KEY_MANAGEMENT(157, 6275339, "X.509 Certificate for Key Management"),
        CARD_AUTHENTICATION(158, 6275329, "X.509 Certificate for Card Authentication"),
        RETIRED1(130, 6275341, "X.509 Certificate for Retired Key 1"),
        RETIRED2(131, 6275342, "X.509 Certificate for Retired Key 2"),
        RETIRED3(132, 6275343, "X.509 Certificate for Retired Key 3"),
        RETIRED4(133, 6275344, "X.509 Certificate for Retired Key 4"),
        RETIRED5(134, 6275345, "X.509 Certificate for Retired Key 5"),
        RETIRED6(135, 6275346, "X.509 Certificate for Retired Key 6"),
        RETIRED7(136, 6275347, "X.509 Certificate for Retired Key 7"),
        RETIRED8(137, 6275348, "X.509 Certificate for Retired Key 8"),
        RETIRED9(138, 6275349, "X.509 Certificate for Retired Key 9"),
        RETIRED10(139, 6275350, "X.509 Certificate for Retired Key 10"),
        RETIRED11(140, 6275351, "X.509 Certificate for Retired Key 11"),
        RETIRED12(141, 6275352, "X.509 Certificate for Retired Key 12"),
        RETIRED13(142, 6275353, "X.509 Certificate for Retired Key 13"),
        RETIRED14(143, 6275354, "X.509 Certificate for Retired Key 14"),
        RETIRED15(144, 6275355, "X.509 Certificate for Retired Key 15"),
        RETIRED16(145, 6275356, "X.509 Certificate for Retired Key 16"),
        RETIRED17(146, 6275357, "X.509 Certificate for Retired Key 17"),
        RETIRED18(147, 6275358, "X.509 Certificate for Retired Key 18"),
        RETIRED19(148, 6275359, "X.509 Certificate for Retired Key 19"),
        RETIRED20(149, 6275360, "X.509 Certificate for Retired Key 20");

        final int slot;
        final int tag;
        final String alias;

        private Key(int slot, int tag, String alias) {
            this.slot = slot;
            this.tag = tag;
            this.alias = alias;
        }

        public static Key of(String name) {
            if (name == null) {
                return null;
            }
            if (name.length() == 2) {
                int slot = Integer.parseInt(name, 16);
                for (Key key : Key.values()) {
                    if (key.slot != slot) continue;
                    return key;
                }
            } else {
                for (Key key : Key.values()) {
                    if (!key.name().equalsIgnoreCase(name) && !key.alias.equalsIgnoreCase(name)) continue;
                    return key;
                }
            }
            return null;
        }
    }
}

