/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.json-io.util.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jsign.json-io.util.io.FastPushbackReader;
import net.jsign.json-io.util.io.JsonIoException;
import net.jsign.json-io.util.io.JsonObject;
import net.jsign.json-io.util.io.JsonReader;

class JsonParser {
    private static final Map<String, String> stringCache = new HashMap<String, String>();
    private final FastPushbackReader input;
    private final Map<Long, JsonObject> objsRead;
    private final StringBuilder strBuf = new StringBuilder(256);
    private final StringBuilder hexBuf = new StringBuilder();
    private final StringBuilder numBuf = new StringBuilder();
    private final boolean useMaps;
    private final Map<String, String> typeNameMap;
    private final int maxParseDepth;
    private int curParseDepth = 0;

    static {
        stringCache.put("", "");
        stringCache.put("true", "true");
        stringCache.put("True", "True");
        stringCache.put("TRUE", "TRUE");
        stringCache.put("false", "false");
        stringCache.put("False", "False");
        stringCache.put("FALSE", "FALSE");
        stringCache.put("null", "null");
        stringCache.put("yes", "yes");
        stringCache.put("Yes", "Yes");
        stringCache.put("YES", "YES");
        stringCache.put("no", "no");
        stringCache.put("No", "No");
        stringCache.put("NO", "NO");
        stringCache.put("on", "on");
        stringCache.put("On", "On");
        stringCache.put("ON", "ON");
        stringCache.put("off", "off");
        stringCache.put("Off", "Off");
        stringCache.put("OFF", "OFF");
        stringCache.put("@id", "@id");
        stringCache.put("@ref", "@ref");
        stringCache.put("@items", "@items");
        stringCache.put("@type", "@type");
        stringCache.put("@keys", "@keys");
        stringCache.put("0", "0");
        stringCache.put("1", "1");
        stringCache.put("2", "2");
        stringCache.put("3", "3");
        stringCache.put("4", "4");
        stringCache.put("5", "5");
        stringCache.put("6", "6");
        stringCache.put("7", "7");
        stringCache.put("8", "8");
        stringCache.put("9", "9");
    }

    JsonParser(FastPushbackReader reader, Map<Long, JsonObject> objectsMap, Map<String, Object> args, int maxDepth) {
        this.input = reader;
        this.useMaps = Boolean.TRUE.equals(args.get("USE_MAPS"));
        this.objsRead = objectsMap;
        this.typeNameMap = (Map)args.get("TYPE_NAME_MAP_REVERSE");
        this.maxParseDepth = maxDepth;
    }

    private Object readJsonObject() throws IOException {
        boolean done = false;
        String field = null;
        JsonObject<String, Object> object = new JsonObject<String, Object>();
        int state = 0;
        FastPushbackReader in = this.input;
        while (!done) {
            switch (state) {
                case 0: {
                    int c = this.skipWhitespaceRead();
                    if (c == 123) {
                        object.line = in.getLine();
                        object.col = in.getCol();
                        c = this.skipWhitespaceRead();
                        if (c == 125) {
                            return "~!o~";
                        }
                        in.unread(c);
                        state = 1;
                        ++this.curParseDepth;
                        break;
                    }
                    this.error("Input is invalid JSON; object does not start with '{', c=" + c);
                    break;
                }
                case 1: {
                    int c = this.skipWhitespaceRead();
                    if (c == 34) {
                        field = this.readString();
                        c = this.skipWhitespaceRead();
                        if (c != 58) {
                            this.error("Expected ':' between string field and value");
                        }
                        if (field.startsWith("@")) {
                            if (field.equals("@t")) {
                                field = stringCache.get("@type");
                            } else if (field.equals("@i")) {
                                field = stringCache.get("@id");
                            } else if (field.equals("@r")) {
                                field = stringCache.get("@ref");
                            } else if (field.equals("@k")) {
                                field = stringCache.get("@keys");
                            } else if (field.equals("@e")) {
                                field = stringCache.get("@items");
                            }
                        }
                        state = 2;
                        break;
                    }
                    this.error("Expected quote");
                    break;
                }
                case 2: {
                    String substitute;
                    if (field == null) {
                        field = "@items";
                    }
                    Object value = this.readValue(object);
                    if ("@type".equals(field) && this.typeNameMap != null && (substitute = this.typeNameMap.get(value)) != null) {
                        value = substitute;
                    }
                    object.put(field, value);
                    if ("@id".equals(field)) {
                        this.objsRead.put((Long)value, object);
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    int c = this.skipWhitespaceRead();
                    if (c == -1) {
                        this.error("EOF reached before closing '}'");
                    }
                    if (c == 125) {
                        done = true;
                        --this.curParseDepth;
                        break;
                    }
                    if (c == 44) {
                        state = 1;
                        break;
                    }
                    this.error("Object not ended with '}'");
                }
            }
        }
        if (this.useMaps && object.isLogicalPrimitive()) {
            return object.getPrimitiveValue();
        }
        return object;
    }

    Object readValue(JsonObject object) throws IOException {
        if (this.curParseDepth > this.maxParseDepth) {
            return this.error("Maximum parsing depth exceeded");
        }
        int c = this.skipWhitespaceRead();
        if (c == 34) {
            return this.readString();
        }
        if (c >= 48 && c <= 57 || c == 45 || c == 78 || c == 73) {
            return this.readNumber(c);
        }
        switch (c) {
            case 123: {
                this.input.unread(123);
                return this.readJsonObject();
            }
            case 91: {
                return this.readArray(object);
            }
            case 93: {
                this.input.unread(93);
                return "~!a~";
            }
            case 70: 
            case 102: {
                this.readToken("false");
                return Boolean.FALSE;
            }
            case 78: 
            case 110: {
                this.readToken("null");
                return null;
            }
            case 84: 
            case 116: {
                this.readToken("true");
                return Boolean.TRUE;
            }
            case -1: {
                this.error("EOF reached prematurely");
            }
        }
        return this.error("Unknown JSON value type");
    }

    private Object readArray(JsonObject object) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        ++this.curParseDepth;
        while (true) {
            int c;
            Object o;
            if ((o = this.readValue(object)) != "~!a~") {
                array.add(o);
            }
            if ((c = this.skipWhitespaceRead()) == 93) break;
            if (c == 44) continue;
            this.error("Expected ',' or ']' inside array");
        }
        --this.curParseDepth;
        return array.toArray();
    }

    private void readToken(String token) throws IOException {
        int len = token.length();
        int i = 1;
        while (i < len) {
            int c = this.input.read();
            if (c == -1) {
                this.error("EOF reached while reading token: " + token);
            }
            c = Character.toLowerCase((char)c);
            char loTokenChar = token.charAt(i);
            if (loTokenChar != c) {
                this.error("Expected token: " + token);
            }
            ++i;
        }
    }

    private Number readNumber(int c) throws IOException {
        FastPushbackReader in = this.input;
        boolean isFloat = false;
        if (JsonReader.isAllowNanAndInfinity() && (c == 45 || c == 78 || c == 73)) {
            boolean isNeg;
            boolean bl = isNeg = c == 45;
            if (isNeg) {
                c = this.input.read();
            }
            if (c == 73) {
                this.readToken("infinity");
                return isNeg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (78 == c) {
                this.readToken("nan");
                return Double.NaN;
            }
            this.input.unread(c);
            c = 45;
        }
        StringBuilder number = this.numBuf;
        number.setLength(0);
        number.appendCodePoint(c);
        while (true) {
            if ((c = in.read()) >= 48 && c <= 57 || c == 45 || c == 43) {
                number.appendCodePoint(c);
                continue;
            }
            if (c != 46 && c != 101 && c != 69) break;
            number.appendCodePoint(c);
            isFloat = true;
        }
        if (c != -1) {
            in.unread(c);
        }
        try {
            if (isFloat) {
                return Double.parseDouble(number.toString());
            }
            return Long.parseLong(number.toString());
        }
        catch (Exception e) {
            return (Number)this.error("Invalid number: " + number, e);
        }
    }

    private String readString() throws IOException {
        StringBuilder str = this.strBuf;
        StringBuilder hex = this.hexBuf;
        str.setLength(0);
        int state = 0;
        FastPushbackReader in = this.input;
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                this.error("EOF reached while reading JSON string");
            }
            if (state == 0) {
                if (c == 34) break;
                if (c == 92) {
                    state = 1;
                    continue;
                }
                str.appendCodePoint(c);
                continue;
            }
            if (state == 1) {
                switch (c) {
                    case 92: {
                        str.appendCodePoint(92);
                        break;
                    }
                    case 47: {
                        str.appendCodePoint(47);
                        break;
                    }
                    case 34: {
                        str.appendCodePoint(34);
                        break;
                    }
                    case 39: {
                        str.appendCodePoint(39);
                        break;
                    }
                    case 98: {
                        str.appendCodePoint(8);
                        break;
                    }
                    case 102: {
                        str.appendCodePoint(12);
                        break;
                    }
                    case 110: {
                        str.appendCodePoint(10);
                        break;
                    }
                    case 114: {
                        str.appendCodePoint(13);
                        break;
                    }
                    case 116: {
                        str.appendCodePoint(9);
                        break;
                    }
                    case 117: {
                        hex.setLength(0);
                        state = 2;
                        break;
                    }
                    default: {
                        this.error("Invalid character escape sequence specified: " + c);
                    }
                }
                if (c == 117) continue;
                state = 0;
                continue;
            }
            if (c >= 48 && c <= 57 || c >= 65 && c <= 70 || c >= 97 && c <= 102) {
                hex.appendCodePoint((char)c);
                if (hex.length() != 4) continue;
                int value = Integer.parseInt(hex.toString(), 16);
                str.appendCodePoint(value);
                state = 0;
                continue;
            }
            this.error("Expected hexadecimal digits");
        }
        String s = str.toString();
        String translate = stringCache.get(s);
        return translate == null ? s : translate;
    }

    private int skipWhitespaceRead() throws IOException {
        int c;
        FastPushbackReader in = this.input;
        while ((c = in.read()) == 32 || c == 10 || c == 13 || c == 9) {
        }
        return c;
    }

    Object error(String msg) {
        throw new JsonIoException(this.getMessage(msg));
    }

    Object error(String msg, Exception e) {
        throw new JsonIoException(this.getMessage(msg), e);
    }

    String getMessage(String msg) {
        return String.valueOf(msg) + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol() + "\n" + this.input.getLastSnippet();
    }
}

