/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j;

import net.jsign.log4j.Logger;
import net.jsign.log4j.internal.LogManagerStatus;
import net.jsign.log4j.simple.SimpleLoggerContextFactory;
import net.jsign.log4j.spi.LoggerContext;
import net.jsign.log4j.spi.LoggerContextFactory;
import net.jsign.log4j.status.StatusLogger;
import net.jsign.log4j.util.ProviderUtil;
import net.jsign.log4j.util.StackLocatorUtil;

public class LogManager {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String FQCN = LogManager.class.getName();
    private static volatile LoggerContextFactory factory = ProviderUtil.getProvider().getLoggerContextFactory();

    protected LogManager() {
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext) {
        try {
            return factory.getContext(FQCN, loader, null, currentContext);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn("{} Using SimpleLogger", ex.getMessage());
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, loader, null, currentContext);
        }
    }

    private static Class<?> callerClass(Class<?> clazz) {
        if (clazz != null) {
            return clazz;
        }
        Class<?> candidate = StackLocatorUtil.getCallerClass(3);
        if (candidate == null) {
            throw new UnsupportedOperationException("No class provided, and an appropriate one cannot be found.");
        }
        return candidate;
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> cls = LogManager.callerClass(clazz);
        return LogManager.getContext(cls.getClassLoader(), false).getLogger(cls);
    }

    static {
        LogManagerStatus.setInitialized(true);
    }
}

