/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jsign.log4j.Marker;
import net.jsign.log4j.util.StringBuilderFormattable;

public final class MarkerManager {
    private static final ConcurrentMap<String, Marker> MARKERS = new ConcurrentHashMap<String, Marker>();

    public static Marker getMarker(String name) {
        return MARKERS.computeIfAbsent(name, Log4jMarker::new);
    }

    private static void requireNonNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static class Log4jMarker
    implements Marker,
    StringBuilderFormattable {
        private final String name;
        private volatile Marker[] parents;

        private Log4jMarker() {
            this.name = null;
            this.parents = null;
        }

        public Log4jMarker(String name) {
            MarkerManager.requireNonNull(name, "Marker name cannot be null.");
            this.name = name;
            this.parents = null;
        }

        @Override
        public Marker setParents(Marker ... markers) {
            if (markers == null || markers.length == 0) {
                this.parents = null;
            } else {
                Marker[] array = new Marker[markers.length];
                System.arraycopy(markers, 0, array, 0, markers.length);
                this.parents = array;
            }
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Marker[] getParents() {
            Marker[] parentsSnapshot = this.parents;
            if (parentsSnapshot == null) {
                return null;
            }
            return Arrays.copyOf(parentsSnapshot, parentsSnapshot.length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Marker)) {
                return false;
            }
            Marker marker = (Marker)o;
            return this.name.equals(marker.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.formatTo(sb);
            return sb.toString();
        }

        @Override
        public void formatTo(StringBuilder sb) {
            sb.append(this.name);
            Marker[] localParents = this.parents;
            if (localParents != null) {
                Log4jMarker.addParentInfo(sb, localParents);
            }
        }

        private static void addParentInfo(StringBuilder sb, Marker ... parents) {
            sb.append("[ ");
            boolean first = true;
            for (Marker marker : parents) {
                Marker[] p;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(marker.getName());
                Marker[] markerArray = p = marker instanceof Log4jMarker ? ((Log4jMarker)marker).parents : marker.getParents();
                if (p == null) continue;
                Log4jMarker.addParentInfo(sb, p);
            }
            sb.append(" ]");
        }
    }
}

