/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.jsign.log4j.spi.DefaultThreadContextStack;
import net.jsign.log4j.spi.ReadOnlyThreadContextMap;
import net.jsign.log4j.spi.ThreadContextMap;
import net.jsign.log4j.spi.ThreadContextMapFactory;
import net.jsign.log4j.spi.ThreadContextStack;
import net.jsign.log4j.util.PropertiesUtil;
import net.jsign.log4j.util.ProviderUtil;

public final class ThreadContext {
    public static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    public static final ThreadContextStack EMPTY_STACK = new EmptyThreadContextStack();
    private static ThreadContextStack contextStack;
    private static ThreadContextMap contextMap;
    private static ReadOnlyThreadContextMap readOnlyContextMap;

    public static void init() {
        PropertiesUtil properties = PropertiesUtil.getProperties();
        contextStack = properties.getBooleanProperty("disableThreadContextStack") || properties.getBooleanProperty("disableThreadContext") ? new NoOpThreadContextStack() : new DefaultThreadContextStack();
        ThreadContextMapFactory.init();
        contextMap = ProviderUtil.getProvider().getThreadContextMapInstance();
        readOnlyContextMap = contextMap instanceof ReadOnlyThreadContextMap ? (ReadOnlyThreadContextMap)((Object)contextMap) : null;
    }

    public static Map<String, String> getImmutableContext() {
        Map<String, String> map = contextMap.getImmutableMapOrNull();
        return map == null ? EMPTY_MAP : map;
    }

    static {
        ThreadContext.init();
    }

    private static final class NoOpThreadContextStack
    extends EmptyThreadContextStack {
        private NoOpThreadContextStack() {
        }

        @Override
        public boolean add(String ignored) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends String> ignored) {
            return false;
        }

        @Override
        public boolean remove(Object ignored) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> ignored) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> ignored) {
            return false;
        }
    }

    public static interface ContextStack
    extends Serializable,
    Collection<String> {
        public List<String> asList();
    }

    private static class EmptyThreadContextStack
    extends AbstractCollection<String>
    implements ThreadContextStack {
        private EmptyThreadContextStack() {
        }

        @Override
        public List<String> asList() {
            return Collections.emptyList();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Collection && ((Collection)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public <T> T[] toArray(T[] ignored) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(String ignored) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsAll(Collection<?> ignored) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends String> ignored) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> ignored) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> ignored) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

