/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.internal;

import net.jsign.log4j.Level;
import net.jsign.log4j.LogBuilder;
import net.jsign.log4j.Logger;
import net.jsign.log4j.Marker;
import net.jsign.log4j.message.Message;
import net.jsign.log4j.message.SimpleMessage;
import net.jsign.log4j.spi.ExtendedLogger;
import net.jsign.log4j.status.StatusLogger;
import net.jsign.log4j.util.StackLocatorUtil;

public class DefaultLogBuilder
implements LogBuilder {
    private static Message EMPTY_MESSAGE = new SimpleMessage("");
    private static final String FQCN = DefaultLogBuilder.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ExtendedLogger logger;
    private Level level;
    private Marker marker;
    private Throwable throwable;
    private StackTraceElement location;
    private volatile boolean inUse;
    private long threadId;
    private String fqcn = FQCN;

    public DefaultLogBuilder(ExtendedLogger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.threadId = Thread.currentThread().getId();
        this.inUse = level != null;
    }

    public DefaultLogBuilder() {
        this(null, null);
    }

    public LogBuilder reset(ExtendedLogger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.marker = null;
        this.throwable = null;
        this.location = null;
        this.inUse = true;
        return this;
    }

    @Override
    public LogBuilder withThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    @Override
    public void log(String message) {
        if (this.isValid() && this.isEnabled(message)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message));
        }
    }

    @Override
    public void log(String message, Object p0, Object p1) {
        if (this.isValid() && this.isEnabled(message, p0, p1)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message, p0, p1));
        }
    }

    private void logMessage(Message message) {
        try {
            this.logger.logMessage(this.level, this.marker, this.fqcn, this.location, message, this.throwable);
        }
        finally {
            this.inUse = false;
        }
    }

    private boolean isValid() {
        if (!this.inUse) {
            LOGGER.warn("Attempt to reuse LogBuilder was ignored. {}", StackLocatorUtil.getCallerClass(2));
            return false;
        }
        if (this.threadId != Thread.currentThread().getId()) {
            LOGGER.warn("LogBuilder can only be used on the owning thread. {}", StackLocatorUtil.getCallerClass(2));
            return false;
        }
        return true;
    }

    protected boolean isEnabled(String message) {
        return this.logger.isEnabled(this.level, this.marker, message, this.throwable);
    }

    protected boolean isEnabled(String message, Object p0, Object p1) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, message, p0, p1, this.throwable) : this.logger.isEnabled(this.level, this.marker, message, p0, p1);
    }
}

