/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.internal.map;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.jsign.log4j.util.ReadOnlyStringMap;

public class UnmodifiableArrayBackedMap
extends AbstractMap<String, String>
implements Serializable,
ReadOnlyStringMap {
    public static final UnmodifiableArrayBackedMap EMPTY_MAP = new UnmodifiableArrayBackedMap(0);
    private Object[] backingArray;
    private int numEntries;

    private static int getArrayIndexForKey(int entryIndex) {
        return 2 * entryIndex + 1;
    }

    private static int getArrayIndexForValue(int entryIndex) {
        return 2 * entryIndex + 1 + 1;
    }

    public static UnmodifiableArrayBackedMap getMap(Object[] backingArray) {
        if (backingArray == null || backingArray.length == 1) {
            return EMPTY_MAP;
        }
        return new UnmodifiableArrayBackedMap(backingArray);
    }

    private UnmodifiableArrayBackedMap(int capacity) {
        this.backingArray = new Object[capacity * 2 + 1];
        this.backingArray[0] = 0;
    }

    private UnmodifiableArrayBackedMap(Object[] backingArray) {
        this.numEntries = backingArray == null ? 0 : (Integer)backingArray[0];
        this.backingArray = backingArray;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Instance cannot be cleared, reuse EMPTY_MAP instead.");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((String)key);
    }

    public boolean containsKey(String key) {
        int hashCode = key.hashCode();
        for (int i = 0; i < this.numEntries; ++i) {
            if (this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForKey(i)].hashCode() != hashCode || !this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForKey(i)].equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.numEntries; ++i) {
            Object valueInMap = this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForValue(i)];
            if (!(value == null ? valueInMap == null : value.equals(valueInMap))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super String> action) {
        for (int i = 0; i < this.numEntries; ++i) {
            String key = (String)this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForKey(i)];
            String value = (String)this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForValue(i)];
            action.accept(key, value);
        }
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new UnmodifiableEntrySet();
    }

    @Override
    public String get(Object key) {
        return (String)this.getValue((String)key);
    }

    public <V> V getValue(String key) {
        if (this.numEntries == 0) {
            return null;
        }
        int hashCode = key.hashCode();
        for (int i = 0; i < this.numEntries; ++i) {
            if (this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForKey(i)].hashCode() != hashCode || !this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForKey(i)].equals(key)) continue;
            return (V)this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForValue(i)];
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException("put() is not supported, use copyAndPut instead");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException("putAll() is not supported, use copyAndPutAll instead");
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException("remove() is not supported, use copyAndRemove instead");
    }

    @Override
    public int size() {
        return this.numEntries;
    }

    private class UnmodifiableEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private UnmodifiableEntrySet() {
        }

        @Override
        public boolean add(Map.Entry<String, String> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, String>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new UnmodifiableEntryIterator();
        }

        @Override
        public int size() {
            return UnmodifiableArrayBackedMap.this.numEntries;
        }
    }

    private class UnmodifiableEntryIterator
    implements Iterator<Map.Entry<String, String>> {
        private int index;

        private UnmodifiableEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < UnmodifiableArrayBackedMap.this.numEntries;
        }

        @Override
        public Map.Entry<String, String> next() {
            return new UnmodifiableEntry(this.index++);
        }
    }

    private class UnmodifiableEntry
    implements Map.Entry<String, String> {
        private int index;

        public UnmodifiableEntry(int index) {
            this.index = index;
        }

        @Override
        public String getKey() {
            return (String)UnmodifiableArrayBackedMap.this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForKey(this.index)];
        }

        @Override
        public String getValue() {
            return (String)UnmodifiableArrayBackedMap.this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForValue(this.index)];
        }

        @Override
        public int hashCode() {
            String key = (String)UnmodifiableArrayBackedMap.this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForKey(this.index)];
            String value = (String)UnmodifiableArrayBackedMap.this.backingArray[UnmodifiableArrayBackedMap.getArrayIndexForValue(this.index)];
            return Objects.hashCode(key) ^ Objects.hashCode(value);
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException("Cannot update Entry instances in UnmodifiableArrayBackedMap");
        }
    }
}

