/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.message;

import java.util.Arrays;
import java.util.Objects;
import net.jsign.log4j.message.Message;
import net.jsign.log4j.message.ParameterFormatter;
import net.jsign.log4j.util.Constants;
import net.jsign.log4j.util.StringBuilderFormattable;
import net.jsign.log4j.util.StringBuilders;

public class ParameterizedMessage
implements Message,
StringBuilderFormattable {
    private static final ThreadLocal<FormatBufferHolder> FORMAT_BUFFER_HOLDER_REF = Constants.ENABLE_THREADLOCALS ? ThreadLocal.withInitial(() -> new FormatBufferHolder()) : null;
    private final String pattern;
    private transient Object[] args;
    private final transient Throwable throwable;
    private final ParameterFormatter.MessagePatternAnalysis patternAnalysis;
    private String formattedMessage;

    public ParameterizedMessage(String pattern, Object[] args, Throwable throwable) {
        this.args = args;
        this.pattern = pattern;
        this.patternAnalysis = ParameterFormatter.analyzePattern(pattern, args != null ? args.length : 0);
        this.throwable = ParameterizedMessage.determineThrowable(throwable, this.args, this.patternAnalysis);
    }

    private static Throwable determineThrowable(Throwable throwable, Object[] args, ParameterFormatter.MessagePatternAnalysis analysis) {
        Object lastArg;
        if (throwable != null) {
            return throwable;
        }
        if (args != null && args.length > analysis.placeholderCount && (lastArg = args[args.length - 1]) instanceof Throwable) {
            return (Throwable)lastArg;
        }
        return null;
    }

    public ParameterizedMessage(String pattern, Object ... args) {
        this(pattern, args, null);
    }

    public ParameterizedMessage(String pattern, Object arg) {
        this(pattern, new Object[]{arg});
    }

    public ParameterizedMessage(String pattern, Object arg0, Object arg1) {
        this(pattern, new Object[]{arg0, arg1});
    }

    @Override
    public String getFormat() {
        return this.pattern;
    }

    @Override
    public Object[] getParameters() {
        return this.args;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            FormatBufferHolder bufferHolder;
            if (FORMAT_BUFFER_HOLDER_REF == null || (bufferHolder = FORMAT_BUFFER_HOLDER_REF.get()).used) {
                StringBuilder buffer = new StringBuilder(Constants.MAX_REUSABLE_MESSAGE_SIZE);
                this.formatTo(buffer);
                this.formattedMessage = buffer.toString();
            } else {
                bufferHolder.used = true;
                StringBuilder buffer = bufferHolder.buffer;
                try {
                    this.formatTo(buffer);
                    this.formattedMessage = buffer.toString();
                }
                finally {
                    StringBuilders.trimToMaxSize(buffer, Constants.MAX_REUSABLE_MESSAGE_SIZE);
                    buffer.setLength(0);
                    bufferHolder.used = false;
                }
            }
        }
        return this.formattedMessage;
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        if (this.formattedMessage != null) {
            buffer.append(this.formattedMessage);
        } else {
            int argCount = this.args != null ? this.args.length : 0;
            ParameterFormatter.formatMessage(buffer, this.pattern, this.args, argCount, this.patternAnalysis);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ParameterizedMessage)) {
            return false;
        }
        ParameterizedMessage that = (ParameterizedMessage)object;
        return Objects.equals(this.pattern, that.pattern) && Arrays.equals(this.args, that.args);
    }

    public int hashCode() {
        int result = this.pattern != null ? this.pattern.hashCode() : 0;
        result = 31 * result + (this.args != null ? Arrays.hashCode(this.args) : 0);
        return result;
    }

    public String toString() {
        return "ParameterizedMessage[messagePattern=" + this.pattern + ", argCount=" + this.args.length + ", throwableProvided=" + (this.throwable != null) + ']';
    }

    private static final class FormatBufferHolder {
        private final StringBuilder buffer = new StringBuilder(Constants.MAX_REUSABLE_MESSAGE_SIZE);
        private boolean used = false;

        private FormatBufferHolder() {
        }
    }
}

