/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.simple;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import net.jsign.log4j.Level;
import net.jsign.log4j.message.MessageFactory;
import net.jsign.log4j.message.ParameterizedMessageFactory;
import net.jsign.log4j.simple.SimpleLogger;
import net.jsign.log4j.simple.internal.SimpleProvider;
import net.jsign.log4j.spi.ExtendedLogger;
import net.jsign.log4j.spi.LoggerContext;
import net.jsign.log4j.spi.LoggerRegistry;
import net.jsign.log4j.util.PropertiesUtil;
import org.jspecify.annotations.Nullable;

public class SimpleLoggerContext
implements LoggerContext {
    static final SimpleLoggerContext INSTANCE = new SimpleLoggerContext();
    private static final MessageFactory DEFAULT_MESSAGE_FACTORY = ParameterizedMessageFactory.INSTANCE;
    private final PropertiesUtil props;
    private final boolean showLogName;
    private final boolean showShortName;
    private final boolean showDateTime;
    private final boolean showContextMap;
    private final String dateTimeFormat;
    private final Level defaultLevel;
    private final PrintStream stream;
    private final LoggerRegistry<ExtendedLogger> loggerRegistry = new LoggerRegistry();

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT"}, justification="Opens a file retrieved from configuration (Log4j properties)")
    public SimpleLoggerContext() {
        SimpleProvider.Config config = SimpleProvider.Config.INSTANCE;
        this.props = config.props;
        this.showContextMap = config.showContextMap;
        this.showLogName = config.showLogName;
        this.showShortName = config.showShortName;
        this.showDateTime = config.showDateTime;
        this.defaultLevel = config.defaultLevel;
        this.dateTimeFormat = config.dateTimeFormat;
        this.stream = config.stream;
    }

    @Override
    public ExtendedLogger getLogger(String name) {
        return this.getLogger(name, DEFAULT_MESSAGE_FACTORY);
    }

    public ExtendedLogger getLogger(String name, @Nullable MessageFactory messageFactory) {
        MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : DEFAULT_MESSAGE_FACTORY;
        ExtendedLogger oldLogger = this.loggerRegistry.getLogger(name, effectiveMessageFactory);
        if (oldLogger != null) {
            return oldLogger;
        }
        ExtendedLogger newLogger = this.createLogger(name, effectiveMessageFactory);
        this.loggerRegistry.putIfAbsent(name, effectiveMessageFactory, newLogger);
        return this.loggerRegistry.getLogger(name, effectiveMessageFactory);
    }

    private ExtendedLogger createLogger(String name, @Nullable MessageFactory messageFactory) {
        return new SimpleLogger(name, this.defaultLevel, this.showLogName, this.showShortName, this.showDateTime, this.showContextMap, this.dateTimeFormat, messageFactory, this.props, this.stream);
    }
}

