/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.spi;

import java.util.Map;
import java.util.Objects;
import net.jsign.log4j.internal.map.UnmodifiableArrayBackedMap;
import net.jsign.log4j.spi.ThreadContextMap;
import net.jsign.log4j.util.PropertiesUtil;
import net.jsign.log4j.util.ReadOnlyStringMap;

public class DefaultThreadContextMap
implements ThreadContextMap,
ReadOnlyStringMap {
    private ThreadLocal<Object[]> localState;

    public DefaultThreadContextMap() {
        this(PropertiesUtil.getProperties());
    }

    DefaultThreadContextMap(PropertiesUtil properties) {
        this.localState = properties.getBooleanProperty("isThreadContextMapInheritable") ? new InheritableThreadLocal<Object[]>(){

            @Override
            protected Object[] childValue(Object[] parentValue) {
                return parentValue;
            }
        } : new ThreadLocal();
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        Object[] state = this.localState.get();
        return state == null ? null : UnmodifiableArrayBackedMap.getMap(state);
    }

    public String toString() {
        Object[] state = this.localState.get();
        return state == null ? "{}" : UnmodifiableArrayBackedMap.getMap(state).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        Object[] state = this.localState.get();
        result = 31 * result + (state == null ? 0 : UnmodifiableArrayBackedMap.getMap(state).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadContextMap)) {
            return false;
        }
        ThreadContextMap other = (ThreadContextMap)obj;
        UnmodifiableArrayBackedMap map = UnmodifiableArrayBackedMap.getMap(this.localState.get());
        Map<String, String> otherMap = other.getImmutableMapOrNull();
        return Objects.equals(map, otherMap);
    }
}

