/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jsign.log4j.message.MessageFactory;
import net.jsign.log4j.message.ParameterizedMessageFactory;
import net.jsign.log4j.spi.ExtendedLogger;
import org.jspecify.annotations.Nullable;

public class LoggerRegistry<T extends ExtendedLogger> {
    private final Map<String, Map<MessageFactory, T>> loggerByMessageFactoryByName = new HashMap<String, Map<MessageFactory, T>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable T getLogger(String name, @Nullable MessageFactory messageFactory) {
        Objects.requireNonNull(name, "name");
        this.readLock.lock();
        try {
            @Nullable Map<MessageFactory, T> loggerByMessageFactory = this.loggerByMessageFactoryByName.get(name);
            MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : ParameterizedMessageFactory.INSTANCE;
            ExtendedLogger extendedLogger = loggerByMessageFactory == null ? null : (ExtendedLogger)loggerByMessageFactory.get(effectiveMessageFactory);
            return (T)extendedLogger;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIfAbsent(String name, @Nullable MessageFactory messageFactory, T logger) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(logger, "logger");
        this.writeLock.lock();
        try {
            MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : ParameterizedMessageFactory.INSTANCE;
            this.loggerByMessageFactoryByName.computeIfAbsent(name, this::createLoggerRefByMessageFactoryMap).putIfAbsent(effectiveMessageFactory, logger);
            if (!name.equals(logger.getName()) || !effectiveMessageFactory.equals(logger.getMessageFactory())) {
                this.loggerByMessageFactoryByName.computeIfAbsent(logger.getName(), this::createLoggerRefByMessageFactoryMap).putIfAbsent(logger.getMessageFactory(), logger);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<MessageFactory, T> createLoggerRefByMessageFactoryMap(String ignored) {
        return new WeakHashMap();
    }
}

