/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.status;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import net.jsign.log4j.Level;
import net.jsign.log4j.Marker;
import net.jsign.log4j.message.Message;
import net.jsign.log4j.message.MessageFactory;
import net.jsign.log4j.message.ParameterizedNoReferenceMessageFactory;
import net.jsign.log4j.spi.AbstractLogger;
import net.jsign.log4j.status.StatusConsoleListener;
import net.jsign.log4j.status.StatusData;
import net.jsign.log4j.status.StatusListener;

public class StatusLogger
extends AbstractLogger {
    static final Level DEFAULT_FALLBACK_LISTENER_LEVEL = Level.ERROR;
    private final Config config;
    private final StatusConsoleListener fallbackListener;
    private final List<StatusListener> listeners;
    private final transient ReadWriteLock listenerLock = new ReentrantReadWriteLock();
    private final transient Lock listenerReadLock = this.listenerLock.readLock();
    private final transient Lock listenerWriteLock = this.listenerLock.writeLock();
    private final Queue<StatusData> buffer = new ConcurrentLinkedQueue<StatusData>();

    StatusLogger() {
        this(StatusLogger.class.getSimpleName(), ParameterizedNoReferenceMessageFactory.INSTANCE, Config.getInstance(), new StatusConsoleListener(Objects.requireNonNull(Config.getInstance().fallbackListenerLevel)));
    }

    public StatusLogger(String name, MessageFactory messageFactory, Config config, StatusConsoleListener fallbackListener) {
        super(Objects.requireNonNull(name, "name"), Objects.requireNonNull(messageFactory, "messageFactory"));
        this.config = Objects.requireNonNull(config, "config");
        this.fallbackListener = Objects.requireNonNull(fallbackListener, "fallbackListener");
        this.listeners = new ArrayList<StatusListener>();
    }

    public static StatusLogger getLogger() {
        return InstanceHolder.INSTANCE;
    }

    public Level getLevel() {
        Level leastSpecificLevel = this.fallbackListener.getStatusLevel();
        for (int listenerIndex = 0; listenerIndex < this.listeners.size(); ++listenerIndex) {
            StatusListener listener = this.listeners.get(listenerIndex);
            Level listenerLevel = listener.getStatusLevel();
            if (!listenerLevel.isLessSpecificThan(leastSpecificLevel)) continue;
            leastSpecificLevel = listenerLevel;
        }
        return leastSpecificLevel;
    }

    @Override
    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"})
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable throwable) {
        try {
            StatusData statusData = this.createStatusData(fqcn, level, message, throwable);
            this.buffer(statusData);
            this.notifyListeners(statusData);
        }
        catch (Exception error) {
            error.printStackTrace(System.err);
        }
    }

    private void buffer(StatusData statusData) {
        if (this.config.bufferCapacity == 0) {
            return;
        }
        this.buffer.add(statusData);
        while (this.buffer.size() >= this.config.bufferCapacity) {
            this.buffer.remove();
        }
    }

    private void notifyListeners(StatusData statusData) {
        boolean foundListeners;
        this.listenerReadLock.lock();
        try {
            foundListeners = !this.listeners.isEmpty();
            this.listeners.forEach(listener -> this.notifyListener((StatusListener)listener, statusData));
        }
        finally {
            this.listenerReadLock.unlock();
        }
        if (!foundListeners) {
            this.notifyListener(this.fallbackListener, statusData);
        }
    }

    private void notifyListener(StatusListener listener, StatusData statusData) {
        boolean levelEnabled = this.isLevelEnabled(listener.getStatusLevel(), statusData.getLevel());
        if (levelEnabled) {
            listener.log(statusData);
        }
    }

    private StatusData createStatusData(@Nullable String fqcn, Level level, Message message, @Nullable Throwable throwable) {
        StackTraceElement caller = StatusLogger.getStackTraceElement(fqcn);
        Instant instant = Instant.now();
        return new StatusData(caller, level, message, throwable, null, this.config.instantFormatter, instant);
    }

    @Nullable
    private static StackTraceElement getStackTraceElement(@Nullable String fqcn) {
        StackTraceElement[] stackTrace;
        if (fqcn == null) {
            return null;
        }
        boolean next = false;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (next && !fqcn.equals(className)) {
                return element;
            }
            if (fqcn.equals(className)) {
                next = true;
                continue;
            }
            if ("?".equals(className)) break;
        }
        return null;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, Object message, Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level messageLevel, Marker marker) {
        Objects.requireNonNull(messageLevel, "messageLevel");
        Level loggerLevel = this.getLevel();
        return this.isLevelEnabled(loggerLevel, messageLevel);
    }

    private boolean isLevelEnabled(Level filteringLevel, Level messageLevel) {
        return this.config.debugEnabled || filteringLevel.isLessSpecificThan(messageLevel);
    }

    public static final class Config {
        private static final Config INSTANCE = new Config();
        final boolean debugEnabled;
        final int bufferCapacity;
        @Nullable
        final Level fallbackListenerLevel;
        @Nullable
        final DateTimeFormatter instantFormatter;

        private Config() {
            this(PropertiesUtilsDouble.readAllAvailableProperties());
        }

        private Config(Map<String, Object> normalizedProperties) {
            this.debugEnabled = Config.readDebugEnabled(normalizedProperties);
            this.bufferCapacity = Config.readBufferCapacity(normalizedProperties);
            this.fallbackListenerLevel = Config.readFallbackListenerLevel(normalizedProperties);
            this.instantFormatter = Config.readInstantFormatter(normalizedProperties);
        }

        public static Config getInstance() {
            return INSTANCE;
        }

        private static boolean readDebugEnabled(Map<String, Object> normalizedProperties) {
            String debug = PropertiesUtilsDouble.readProperty(normalizedProperties, "log4j2.debug");
            return debug != null && !"false".equalsIgnoreCase(debug);
        }

        private static int readBufferCapacity(Map<String, Object> normalizedProperties) {
            String propertyName = "log4j2.status.entries";
            String capacityString = PropertiesUtilsDouble.readProperty(normalizedProperties, "log4j2.status.entries");
            boolean defaultCapacity = false;
            int effectiveCapacity = 0;
            if (capacityString != null) {
                try {
                    int capacity = Integer.parseInt(capacityString);
                    if (capacity < 0) {
                        String message = String.format("was expecting a positive buffer capacity, found: %d", capacity);
                        throw new IllegalArgumentException(message);
                    }
                    effectiveCapacity = capacity;
                }
                catch (Exception error) {
                    String message = String.format("Failed reading the buffer capacity from the `%s` property: `%s`. Falling back to the default: %d.", "log4j2.status.entries", capacityString, 0);
                    IllegalArgumentException extendedError = new IllegalArgumentException(message, error);
                    extendedError.printStackTrace(System.err);
                }
            }
            return effectiveCapacity;
        }

        private static Level readFallbackListenerLevel(Map<String, Object> normalizedProperties) {
            String propertyName = "log4j2.StatusLogger.level";
            String level = PropertiesUtilsDouble.readProperty(normalizedProperties, "log4j2.StatusLogger.level");
            Level defaultLevel = DEFAULT_FALLBACK_LISTENER_LEVEL;
            try {
                return level != null ? Level.valueOf(level) : defaultLevel;
            }
            catch (Exception error) {
                String message = String.format("Failed reading the level from the `%s` property: `%s`. Falling back to the default: `%s`.", "log4j2.StatusLogger.level", level, defaultLevel);
                IllegalArgumentException extendedError = new IllegalArgumentException(message, error);
                extendedError.printStackTrace(System.err);
                return defaultLevel;
            }
        }

        @Nullable
        private static DateTimeFormatter readInstantFormatter(Map<String, Object> normalizedProperties) {
            ZoneId defaultZoneId;
            DateTimeFormatter formatter;
            String formatPropertyName = "log4j2.StatusLogger.dateFormat";
            String format = PropertiesUtilsDouble.readProperty(normalizedProperties, "log4j2.StatusLogger.dateFormat");
            if (format == null) {
                return null;
            }
            try {
                formatter = DateTimeFormatter.ofPattern(format);
            }
            catch (Exception error) {
                String message = String.format("failed reading the instant format from the `%s` property: `%s`", "log4j2.StatusLogger.dateFormat", format);
                IllegalArgumentException extendedError = new IllegalArgumentException(message, error);
                extendedError.printStackTrace(System.err);
                return null;
            }
            String zonePropertyName = "log4j2.StatusLogger.dateFormatZone";
            String zoneIdString = PropertiesUtilsDouble.readProperty(normalizedProperties, "log4j2.StatusLogger.dateFormatZone");
            ZoneId zoneId = defaultZoneId = ZoneId.systemDefault();
            if (zoneIdString != null) {
                try {
                    zoneId = ZoneId.of(zoneIdString);
                }
                catch (Exception error) {
                    String message = String.format("Failed reading the instant formatting zone ID from the `%s` property: `%s`. Falling back to the default: `%s`.", "log4j2.StatusLogger.dateFormatZone", zoneIdString, defaultZoneId);
                    IllegalArgumentException extendedError = new IllegalArgumentException(message, error);
                    extendedError.printStackTrace(System.err);
                }
            }
            return formatter.withZone(zoneId);
        }
    }

    private static final class InstanceHolder {
        private static volatile StatusLogger INSTANCE = new StatusLogger();
    }

    static final class PropertiesUtilsDouble {
        @Nullable
        static String readProperty(Map<String, Object> normalizedProperties, String propertyName) {
            String normalizedPropertyName = PropertiesUtilsDouble.normalizePropertyName(propertyName);
            Object value = normalizedProperties.get(normalizedPropertyName);
            return value instanceof String ? (String)value : null;
        }

        static Map<String, Object> readAllAvailableProperties() {
            Properties systemProperties = System.getProperties();
            Properties environmentProperties = PropertiesUtilsDouble.readEnvironmentProperties();
            Properties fileProvidedProperties = PropertiesUtilsDouble.readPropertiesFile("log4j2.StatusLogger.properties");
            return PropertiesUtilsDouble.normalizeProperties(systemProperties, environmentProperties, fileProvidedProperties);
        }

        private static Properties readEnvironmentProperties() {
            Properties properties = new Properties();
            properties.putAll(System.getenv());
            return properties;
        }

        static Properties readPropertiesFile(String propertiesFileName) {
            Properties properties = new Properties();
            String resourceName = '/' + propertiesFileName;
            URL url = StatusLogger.class.getResource(resourceName);
            if (url == null) {
                return properties;
            }
            try (InputStream stream = url.openStream();){
                properties.load(stream);
            }
            catch (IOException error) {
                String message = String.format("failed reading properties from `%s`", propertiesFileName);
                RuntimeException extendedError = new RuntimeException(message, error);
                extendedError.printStackTrace(System.err);
            }
            return properties;
        }

        private static Map<String, Object> normalizeProperties(Properties ... propertiesList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Properties properties : propertiesList) {
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> {
                    boolean relevant = PropertiesUtilsDouble.isRelevantPropertyName(name);
                    if (relevant) {
                        String normalizedName = PropertiesUtilsDouble.normalizePropertyName((String)name);
                        map.put(normalizedName, value);
                    }
                }));
            }
            return map;
        }

        private static boolean isRelevantPropertyName(@Nullable Object propertyName) {
            return propertyName instanceof String && ((String)propertyName).matches("^(?i)log4j.*");
        }

        private static String normalizePropertyName(String propertyName) {
            return propertyName.replaceAll("[._-]", "").replaceAll("\\P{InBasic_Latin}", ".").toLowerCase(Locale.US).replaceAll("^log4j2", "log4j");
        }
    }
}

