/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.jsign.log4j.util.Cast;
import net.jsign.log4j.util.Lazy;

final class LazyUtil {
    private static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };

    static Object wrapNull(Object value) {
        return value == null ? NULL : value;
    }

    static <T> T unwrapNull(Object value) {
        return value == NULL ? null : (T)Cast.cast(value);
    }

    static class SafeLazy<T>
    implements Lazy<T> {
        private final Lock lock = new ReentrantLock();
        private final Supplier<T> supplier;
        private volatile Object value;

        SafeLazy(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T value() {
            Object value = this.value;
            if (value == null) {
                this.lock.lock();
                try {
                    value = this.value;
                    if (value == null) {
                        value = this.supplier.get();
                        this.value = LazyUtil.wrapNull(value);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return LazyUtil.unwrapNull(value);
        }

        public boolean isInitialized() {
            return this.value != null;
        }

        public String toString() {
            return this.isInitialized() ? String.valueOf(this.value) : "Lazy value not initialized";
        }
    }
}

