/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.jsign.log4j.Logger;
import net.jsign.log4j.status.StatusLogger;
import net.jsign.log4j.util.Cast;
import net.jsign.log4j.util.LazyBoolean;
import net.jsign.log4j.util.PropertiesUtil;

public final class LoaderUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static Boolean ignoreTCCL;
    static final RuntimePermission GET_CLASS_LOADER;
    static final LazyBoolean GET_CLASS_LOADER_DISABLED;
    private static final PrivilegedAction<ClassLoader> TCCL_GETTER;

    private LoaderUtil() {
    }

    public static ClassLoader getThreadContextClassLoader() {
        try {
            return GET_CLASS_LOADER_DISABLED.getAsBoolean() ? LoaderUtil.getThisClassLoader() : LoaderUtil.runPrivileged(TCCL_GETTER);
        }
        catch (SecurityException ignored) {
            return null;
        }
    }

    private static ClassLoader getThisClassLoader() {
        return LoaderUtil.class.getClassLoader();
    }

    private static <T> T runPrivileged(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = LoaderUtil.isIgnoreTccl() ? LoaderUtil.getThisClassLoader() : LoaderUtil.getThreadContextClassLoader();
        if (classLoader == null) {
            classLoader = LoaderUtil.getThisClassLoader();
        }
        return Class.forName(className, true, classLoader);
    }

    public static <T> T newInstanceOf(Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    public static <T> T newInstanceOf(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Class clazz = (Class)Cast.cast(LoaderUtil.loadClass(className));
        return LoaderUtil.newInstanceOf(clazz);
    }

    private static boolean isIgnoreTccl() {
        if (ignoreTCCL == null) {
            String ignoreTccl = PropertiesUtil.getProperties().getStringProperty("log4j.ignoreTCL", null);
            ignoreTCCL = ignoreTccl != null && !"false".equalsIgnoreCase(ignoreTccl.trim());
        }
        return ignoreTCCL;
    }

    static Collection<URL> findResources(String resource, boolean useTccl) {
        Collection<UrlResource> urlResources = LoaderUtil.findUrlResources(resource, useTccl);
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(urlResources.size());
        for (UrlResource urlResource : urlResources) {
            resources.add(urlResource.getUrl());
        }
        return resources;
    }

    static Collection<UrlResource> findUrlResources(String resource, boolean useTccl) {
        ClassLoader[] candidates = new ClassLoader[]{useTccl ? LoaderUtil.getThreadContextClassLoader() : null, LoaderUtil.class.getClassLoader(), GET_CLASS_LOADER_DISABLED.getAsBoolean() ? null : ClassLoader.getSystemClassLoader()};
        LinkedHashSet<UrlResource> resources = new LinkedHashSet<UrlResource>();
        for (ClassLoader cl : candidates) {
            if (cl == null) continue;
            try {
                Enumeration<URL> resourceEnum = cl.getResources(resource);
                while (resourceEnum.hasMoreElements()) {
                    resources.add(new UrlResource(cl, resourceEnum.nextElement()));
                }
            }
            catch (IOException error) {
                LOGGER.error("failed to collect resources of name `{}`", resource, error);
            }
        }
        return resources;
    }

    static {
        GET_CLASS_LOADER = new RuntimePermission("getClassLoader");
        GET_CLASS_LOADER_DISABLED = new LazyBoolean(() -> {
            if (System.getSecurityManager() == null) {
                return false;
            }
            try {
                AccessController.checkPermission(GET_CLASS_LOADER);
                return false;
            }
            catch (SecurityException ignored) {
                try {
                    AccessController.doPrivileged(() -> {
                        AccessController.checkPermission(GET_CLASS_LOADER);
                        return null;
                    });
                    return false;
                }
                catch (SecurityException ignore) {
                    return true;
                }
            }
        });
        TCCL_GETTER = new ThreadContextClassLoaderGetter();
    }

    static class UrlResource {
        private final ClassLoader classLoader;
        private final URL url;

        UrlResource(ClassLoader classLoader, URL url) {
            this.classLoader = classLoader;
            this.url = url;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrlResource)) {
                return false;
            }
            UrlResource that = (UrlResource)o;
            return Objects.equals(this.classLoader, that.classLoader) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hashCode(this.classLoader) + Objects.hashCode(this.url);
        }
    }

    private static class ThreadContextClassLoaderGetter
    implements PrivilegedAction<ClassLoader> {
        private ThreadContextClassLoaderGetter() {
        }

        @Override
        public ClassLoader run() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
            ClassLoader thisClassLoader = LoaderUtil.getThisClassLoader();
            if (thisClassLoader != null || GET_CLASS_LOADER_DISABLED.getAsBoolean()) {
                return thisClassLoader;
            }
            return ClassLoader.getSystemClassLoader();
        }
    }
}

