/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import aQute.bnd.annotation.spi.ServiceConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.jsign.log4j.Logger;
import net.jsign.log4j.status.StatusLogger;
import net.jsign.log4j.util.Lazy;
import net.jsign.log4j.util.PropertyFilePropertySource;
import net.jsign.log4j.util.PropertySource;
import net.jsign.log4j.util.ServiceLoaderUtil;

@ServiceConsumer(value=PropertySource.class, resolution="optional", cardinality="multiple")
public final class PropertiesUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Lazy<PropertiesUtil> COMPONENT_PROPERTIES = Lazy.lazy(() -> new PropertiesUtil("log4j2.component.properties", false));
    private static final Pattern DURATION_PATTERN = Pattern.compile("([+-]?\\d+)\\s*(\\w+)?", 2);
    private final Environment environment;

    public PropertiesUtil(String propertiesFileName) {
        this(propertiesFileName, true);
    }

    private PropertiesUtil(String propertiesFileName, boolean useTccl) {
        this(new PropertyFilePropertySource(propertiesFileName, useTccl));
    }

    PropertiesUtil(PropertySource source) {
        this.environment = new Environment(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadClose(InputStream in, Object source) {
        Properties props = new Properties();
        if (null != in) {
            try {
                props.load(in);
            }
            catch (IOException error) {
                LOGGER.error("Unable to read source `{}`", source, error);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException error) {
                    LOGGER.error("Unable to close source `{}`", source, error);
                }
            }
        }
        return props;
    }

    public static PropertiesUtil getProperties() {
        return COMPONENT_PROPERTIES.get();
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    public int getIntegerProperty(String name, int defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Integer.parseInt(prop.trim());
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Unable to read int `{}` from property `{}`. Falling back to the default: `{}`", prop, name, defaultValue, e);
            }
        }
        return defaultValue;
    }

    public String getStringProperty(String name) {
        return this.environment.get(name);
    }

    public String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    private static final class Environment {
        private final Set<PropertySource> sources = ConcurrentHashMap.newKeySet();
        private final ThreadLocal<PropertySource> CURRENT_PROPERTY_SOURCE = new ThreadLocal();

        private Environment(PropertySource propertySource) {
            PropertyFilePropertySource sysProps = new PropertyFilePropertySource("log4j2.system.properties", false);
            try {
                sysProps.forEach((key, value) -> {
                    if (System.getProperty(key) == null) {
                        System.setProperty(key, value);
                    }
                });
            }
            catch (SecurityException e) {
                LOGGER.warn("Unable to set Java system properties from {} file, due to security restrictions.", "log4j2.system.properties", e);
            }
            this.sources.add(propertySource);
            ServiceLoaderUtil.safeStream(PropertySource.class, ServiceLoader.load(PropertySource.class, PropertiesUtil.class.getClassLoader()), LOGGER).forEach(this.sources::add);
        }

        private String get(String key) {
            List<CharSequence> tokens = PropertySource.Util.tokenize(key);
            return this.sources.stream().sorted(PropertySource.Comparator.INSTANCE).map(source -> {
                String normalKey;
                if (!tokens.isEmpty() && (normalKey = Objects.toString(source.getNormalForm(tokens), null)) != null && this.sourceContainsProperty((PropertySource)source, normalKey)) {
                    return this.sourceGetProperty((PropertySource)source, normalKey);
                }
                return this.sourceGetProperty((PropertySource)source, key);
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean sourceContainsProperty(PropertySource source, String key) {
            PropertySource recursiveSource = this.CURRENT_PROPERTY_SOURCE.get();
            if (recursiveSource == null) {
                this.CURRENT_PROPERTY_SOURCE.set(source);
                try {
                    boolean bl = source.containsProperty(key);
                    return bl;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to retrieve Log4j property {} from property source {}.", key, source, e);
                }
                finally {
                    this.CURRENT_PROPERTY_SOURCE.remove();
                }
            }
            LOGGER.warn("Recursive call to `containsProperty()` from property source {}.", recursiveSource);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String sourceGetProperty(PropertySource source, String key) {
            PropertySource recursiveSource = this.CURRENT_PROPERTY_SOURCE.get();
            if (recursiveSource == null) {
                this.CURRENT_PROPERTY_SOURCE.set(source);
                try {
                    String string = source.getProperty(key);
                    return string;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to retrieve Log4j property {} from property source {}.", key, source, e);
                }
                finally {
                    this.CURRENT_PROPERTY_SOURCE.remove();
                }
            }
            LOGGER.warn("Recursive call to `getProperty()` from property source {}.", recursiveSource);
            return null;
        }
    }
}

