/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import java.time.temporal.Temporal;
import net.jsign.log4j.util.StringBuilderFormattable;

public final class StringBuilders {
    private static final Class<?> timeClass;
    private static final Class<?> dateClass;

    public static void appendValue(StringBuilder stringBuilder, Object obj) {
        if (!StringBuilders.appendSpecificTypes(stringBuilder, obj)) {
            stringBuilder.append(obj);
        }
    }

    public static boolean appendSpecificTypes(StringBuilder stringBuilder, Object obj) {
        if (obj == null || obj instanceof String) {
            stringBuilder.append((String)obj);
        } else if (obj instanceof StringBuilderFormattable) {
            ((StringBuilderFormattable)obj).formatTo(stringBuilder);
        } else if (obj instanceof CharSequence) {
            stringBuilder.append((CharSequence)obj);
        } else if (obj instanceof Integer) {
            stringBuilder.append((Integer)obj);
        } else if (obj instanceof Long) {
            stringBuilder.append((Long)obj);
        } else if (obj instanceof Double) {
            stringBuilder.append((Double)obj);
        } else if (obj instanceof Boolean) {
            stringBuilder.append((Boolean)obj);
        } else if (obj instanceof Character) {
            stringBuilder.append(((Character)obj).charValue());
        } else if (obj instanceof Short) {
            stringBuilder.append(((Short)obj).shortValue());
        } else if (obj instanceof Float) {
            stringBuilder.append(((Float)obj).floatValue());
        } else if (obj instanceof Byte) {
            stringBuilder.append(((Byte)obj).byteValue());
        } else if (StringBuilders.isTime(obj) || StringBuilders.isDate(obj) || obj instanceof Temporal) {
            stringBuilder.append(obj);
        } else {
            return false;
        }
        return true;
    }

    private static boolean isTime(Object obj) {
        return timeClass != null && timeClass.isAssignableFrom(obj.getClass());
    }

    private static boolean isDate(Object obj) {
        return dateClass != null && dateClass.isAssignableFrom(obj.getClass());
    }

    public static void trimToMaxSize(StringBuilder stringBuilder, int maxSize) {
        if (stringBuilder != null && stringBuilder.capacity() > maxSize) {
            stringBuilder.setLength(maxSize);
            stringBuilder.trimToSize();
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.sql.Time");
        }
        catch (ClassNotFoundException ex) {
            clazz = null;
        }
        timeClass = clazz;
        try {
            clazz = Class.forName("java.sql.Date");
        }
        catch (ClassNotFoundException ex) {
            clazz = null;
        }
        dateClass = clazz;
    }
}

