/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import net.jsign.log4j.Logger;
import net.jsign.log4j.status.StatusLogger;
import net.jsign.log4j.util.Constants;
import net.jsign.log4j.util.PropertiesUtil;

public class Unbox {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int RINGBUFFER_SIZE = Unbox.calculateRingBufferSize("log4j.unbox.ringbuffer.size");
    private static final int MASK = RINGBUFFER_SIZE - 1;
    private static ThreadLocal<State> threadLocalState = new ThreadLocal();
    private static WebSafeState webSafeState = new WebSafeState();

    private static int calculateRingBufferSize(String propertyName) {
        String userPreferredRBSize = PropertiesUtil.getProperties().getStringProperty(propertyName, String.valueOf(32));
        try {
            int size = Integer.parseInt(userPreferredRBSize.trim());
            if (size < 32) {
                size = 32;
                LOGGER.warn("Invalid {} {}, using minimum size {}.", propertyName, userPreferredRBSize, 32);
            }
            return Unbox.ceilingNextPowerOfTwo(size);
        }
        catch (Exception ex) {
            LOGGER.warn("Invalid {} {}, using default size {}.", propertyName, userPreferredRBSize, 32);
            return 32;
        }
    }

    private static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static StringBuilder box(int value) {
        return Unbox.getSB().append(value);
    }

    private static State getState() {
        State state = threadLocalState.get();
        if (state == null) {
            state = new State();
            threadLocalState.set(state);
        }
        return state;
    }

    private static StringBuilder getSB() {
        return Constants.ENABLE_THREADLOCALS ? Unbox.getState().getStringBuilder() : webSafeState.getStringBuilder();
    }

    private static class State {
        private final StringBuilder[] ringBuffer = new StringBuilder[Unbox.access$000()];
        private int current;

        State() {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                this.ringBuffer[i] = new StringBuilder(21);
            }
        }

        public StringBuilder getStringBuilder() {
            StringBuilder result = this.ringBuffer[MASK & this.current++];
            result.setLength(0);
            return result;
        }
    }

    private static class WebSafeState {
        private final ThreadLocal<StringBuilder[]> ringBuffer = new ThreadLocal();
        private final ThreadLocal<int[]> current = new ThreadLocal();

        private WebSafeState() {
        }

        public StringBuilder getStringBuilder() {
            StringBuilder[] array = this.ringBuffer.get();
            if (array == null) {
                array = new StringBuilder[RINGBUFFER_SIZE];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = new StringBuilder(21);
                }
                this.ringBuffer.set(array);
                this.current.set(new int[1]);
            }
            int[] index = this.current.get();
            int n = index[0];
            index[0] = n + 1;
            StringBuilder result = array[MASK & n];
            result.setLength(0);
            return result;
        }
    }
}

