/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.mscab;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.security.MessageDigest;
import net.jsign.ChannelUtils;
import net.jsign.mscab.CFReserve;

class CFHeader {
    public long csumHeader;
    public long cbCabinet;
    public long csumFolders;
    public long coffFiles;
    public long csumFiles;
    public byte versionMinor;
    public byte versionMajor;
    public int cFolders;
    public int cFiles;
    public int flags;
    public int setID;
    public int iCabinet;
    public int cbCFHeader;
    public short cbCFFolder;
    public short cbCFData;
    public CFReserve reserve;
    public byte[] szCabinetPrev;
    public byte[] szDiskPrev;
    public byte[] szCabinetNext;
    public byte[] szDiskNext;

    public CFHeader() {
    }

    public CFHeader(CFHeader header) {
        this.csumHeader = header.csumHeader;
        this.cbCabinet = header.cbCabinet;
        this.csumFolders = header.csumFolders;
        this.coffFiles = header.coffFiles;
        this.csumFiles = header.csumFiles;
        this.versionMinor = header.versionMinor;
        this.versionMajor = header.versionMajor;
        this.cFolders = header.cFolders;
        this.cFiles = header.cFiles;
        this.flags = header.flags;
        this.setID = header.setID;
        this.iCabinet = header.iCabinet;
        this.cbCFHeader = header.cbCFHeader;
        this.cbCFFolder = header.cbCFFolder;
        this.cbCFData = header.cbCFData;
        this.reserve = header.reserve != null ? new CFReserve(header.reserve) : null;
        this.szCabinetPrev = header.szCabinetPrev;
        this.szDiskPrev = header.szDiskPrev;
        this.szCabinetNext = header.szCabinetNext;
        this.szDiskNext = header.szDiskNext;
    }

    public void read(SeekableByteChannel channel) throws IOException {
        if (channel.size() < 44L) {
            throw new IOException("MSCabinet file too short");
        }
        ByteBuffer buffer = ByteBuffer.allocate(36).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        int signature = buffer.getInt();
        if (signature != 1178817357) {
            throw new IOException("Invalid MSCabinet header signature " + String.format("0x%04x", (long)signature & 0xFFFFFFFFL));
        }
        this.csumHeader = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.cbCabinet = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.csumFolders = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.coffFiles = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.csumFiles = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.versionMinor = buffer.get();
        this.versionMajor = buffer.get();
        this.cFolders = buffer.getShort() & 0xFFFF;
        this.cFiles = buffer.getShort() & 0xFFFF;
        this.flags = buffer.getShort() & 0xFFFF;
        this.setID = buffer.getShort();
        this.iCabinet = buffer.getShort() & 0xFFFF;
        this.reserve = null;
        if (this.isReservePresent()) {
            buffer.clear();
            buffer.limit(4);
            channel.read(buffer);
            buffer.flip();
            this.cbCFHeader = buffer.getShort() & 0xFFFF;
            this.cbCFFolder = (short)(buffer.get() & 0xFF);
            this.cbCFData = (short)(buffer.get() & 0xFF);
            if (this.cbCFHeader > 0) {
                byte[] abReserve = new byte[this.cbCFHeader];
                channel.read(ByteBuffer.wrap(abReserve));
                this.reserve = new CFReserve();
                this.reserve.read(abReserve);
            }
        }
        if (this.hasPreviousCabinet()) {
            this.szCabinetPrev = ChannelUtils.readNullTerminatedString(channel);
            this.szDiskPrev = ChannelUtils.readNullTerminatedString(channel);
        }
        if (this.hasNextCabinet()) {
            this.szCabinetNext = ChannelUtils.readNullTerminatedString(channel);
            this.szDiskNext = ChannelUtils.readNullTerminatedString(channel);
        }
    }

    public void write(SeekableByteChannel channel) throws IOException {
        channel.position(0L);
        ByteBuffer buffer = ByteBuffer.allocate(this.getHeaderSize()).order(ByteOrder.LITTLE_ENDIAN);
        this.write(buffer);
        buffer.flip();
        channel.write(buffer);
    }

    public void write(ByteBuffer buffer) {
        buffer.putInt(1178817357);
        buffer.putInt((int)this.csumHeader);
        buffer.putInt((int)this.cbCabinet);
        buffer.putInt((int)this.csumFolders);
        buffer.putInt((int)this.coffFiles);
        buffer.putInt((int)this.csumFiles);
        buffer.put(this.versionMinor);
        buffer.put(this.versionMajor);
        buffer.putShort((short)this.cFolders);
        buffer.putShort((short)this.cFiles);
        buffer.putShort((short)this.flags);
        buffer.putShort((short)this.setID);
        buffer.putShort((short)this.iCabinet);
        if (this.isReservePresent()) {
            buffer.putShort((short)this.cbCFHeader);
            buffer.put((byte)this.cbCFFolder);
            buffer.put((byte)this.cbCFData);
            if (this.cbCFHeader > 0) {
                buffer.put(this.reserve.toBuffer());
            }
        }
        if (this.hasPreviousCabinet()) {
            buffer.put(this.szCabinetPrev);
            buffer.put(this.szDiskPrev);
        }
        if (this.hasNextCabinet()) {
            buffer.put(this.szCabinetNext);
            buffer.put(this.szDiskNext);
        }
    }

    public int getHeaderSize() {
        int size = 36;
        if (this.isReservePresent()) {
            size += 4 + this.cbCFHeader;
        }
        if (this.hasPreviousCabinet()) {
            size += this.szCabinetPrev.length;
            size += this.szDiskPrev.length;
        }
        if (this.hasNextCabinet()) {
            size += this.szCabinetNext.length;
            size += this.szDiskNext.length;
        }
        return size;
    }

    public void headerDigestUpdate(MessageDigest digest) {
        ByteBuffer buffer = ByteBuffer.allocate(36).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(1178817357);
        buffer.putInt((int)this.cbCabinet);
        buffer.putInt((int)this.csumFolders);
        buffer.putInt((int)this.coffFiles);
        buffer.putInt((int)this.csumFiles);
        buffer.put(this.versionMinor);
        buffer.put(this.versionMajor);
        buffer.putShort((short)this.cFolders);
        buffer.putShort((short)this.cFiles);
        buffer.putShort((short)this.flags);
        buffer.putShort((short)this.setID);
        buffer.putShort((short)this.iCabinet);
        buffer.flip();
        digest.update(buffer);
        if (this.reserve != null && !this.reserve.isEmpty()) {
            this.reserve.digest(digest);
        }
        if (this.hasPreviousCabinet()) {
            digest.update(this.szCabinetPrev);
            digest.update(this.szDiskPrev);
        }
        if (this.hasNextCabinet()) {
            digest.update(this.szCabinetNext);
            digest.update(this.szDiskNext);
        }
    }

    public boolean hasPreviousCabinet() {
        return (1 & this.flags) != 0;
    }

    public boolean hasNextCabinet() {
        return (2 & this.flags) != 0;
    }

    public boolean isReservePresent() {
        return (4 & this.flags) != 0;
    }

    public boolean hasSignature() {
        return this.reserve != null && this.reserve.structure2.length >= 16;
    }

    public void setReserve(CFReserve reserve) {
        int previousSize = this.getHeaderSize();
        this.reserve = reserve;
        int n = this.cbCFHeader = reserve != null ? reserve.size() : 0;
        this.flags = this.cbCFHeader != 0 || this.cbCFFolder != 0 || this.cbCFData != 0 ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        int currentSize = this.getHeaderSize();
        int shift = currentSize - previousSize;
        this.cbCabinet += (long)shift;
        this.coffFiles += (long)shift;
    }
}

