/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.msi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcSipInfo;
import net.jsign.asn1.authenticode.SpcUuid;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.DERNull;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.DigestInfo;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.msi.MSIStreamName;
import net.jsign.poi.poifs.filesystem.DocumentEntry;
import net.jsign.poi.poifs.filesystem.DocumentInputStream;
import net.jsign.poi.poifs.filesystem.DocumentNode;
import net.jsign.poi.poifs.filesystem.Entry;
import net.jsign.poi.poifs.filesystem.POIFSDocument;
import net.jsign.poi.poifs.filesystem.POIFSFileSystem;
import net.jsign.poi.poifs.property.DirectoryProperty;
import net.jsign.poi.poifs.property.DocumentProperty;
import net.jsign.poi.poifs.property.Property;
import net.jsign.poi.util.IOUtils;

public class MSIFile
implements Signable {
    private static final long MSI_HEADER = -3400479537158350111L;
    private static final String DIGITAL_SIGNATURE_ENTRY_NAME = "\u0005DigitalSignature";
    private static final String MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME = "\u0005MsiDigitalSignatureEx";
    private POIFSFileSystem fsRead;
    private POIFSFileSystem fsWrite;
    private SeekableByteChannel channel;
    private File file;

    public static boolean isMSIFile(File file) throws IOException {
        if (file.length() < 8L) {
            return false;
        }
        try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
            boolean bl = in.readLong() == -3400479537158350111L;
            return bl;
        }
    }

    public MSIFile(File file) throws IOException {
        this.file = file;
        try {
            this.fsRead = new POIFSFileSystem(file, true);
            this.fsWrite = new POIFSFileSystem(file, false);
        }
        catch (ClassCastException | IllegalStateException | IndexOutOfBoundsException e) {
            throw new IOException("MSI file format error", e);
        }
    }

    public MSIFile(SeekableByteChannel channel) throws IOException {
        this.channel = channel;
        FilterInputStream in = new FilterInputStream(Channels.newInputStream(channel)){

            @Override
            public void close() {
            }
        };
        this.fsWrite = this.fsRead = new POIFSFileSystem(in);
    }

    @Override
    public void close() throws IOException {
        try (POIFSFileSystem fsRead = this.fsRead;
             POIFSFileSystem fsWrite = this.fsWrite;){
            SeekableByteChannel channel = this.channel;
            Throwable throwable = null;
            if (channel != null) {
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    channel.close();
                }
            }
        }
    }

    public boolean hasExtendedSignature() {
        try {
            this.fsRead.getRoot().getEntry(MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        MessageDigest digest = digestAlgorithm.getMessageDigest();
        try {
            if (this.fsRead.getRoot().hasEntry(MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME)) {
                Entry msiDigitalSignatureExEntry = this.fsRead.getRoot().getEntry(MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME);
                POIFSDocument msiDigitalSignatureExDocument = new POIFSDocument((DocumentNode)msiDigitalSignatureExEntry);
                this.updateDigest(digest, msiDigitalSignatureExDocument);
            }
            this.updateDigest(digest, this.fsRead.getPropertyTable().getRoot());
            return digest.digest();
        }
        catch (ClassCastException | IllegalArgumentException | IllegalStateException | IndexOutOfBoundsException | NoSuchElementException e) {
            throw new IOException("MSI file format error", e);
        }
    }

    private void updateDigest(MessageDigest digest, DirectoryProperty node) {
        TreeMap<MSIStreamName, Property> sortedEntries = new TreeMap<MSIStreamName, Property>();
        for (Property child : node) {
            sortedEntries.put(new MSIStreamName(child.getName()), child);
        }
        for (Property property : sortedEntries.values()) {
            if (!property.isDirectory()) {
                String name = new MSIStreamName(property.getName()).decode();
                if (name.equals(DIGITAL_SIGNATURE_ENTRY_NAME) || name.equals(MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME)) continue;
                POIFSDocument document = new POIFSDocument((DocumentProperty)property, this.fsRead);
                this.updateDigest(digest, document);
                continue;
            }
            this.updateDigest(digest, (DirectoryProperty)property);
        }
        byte[] classId = new byte[16];
        node.getStorageClsid().write(classId, 0);
        digest.update(classId);
    }

    private void updateDigest(MessageDigest digest, POIFSDocument document) {
        long remaining = document.getSize();
        for (ByteBuffer buffer : document) {
            int size = buffer.remaining();
            buffer.limit(buffer.position() + (int)Math.min(remaining, (long)size));
            digest.update(buffer);
            remaining -= (long)size;
        }
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        SpcUuid uuid = new SpcUuid("F1100C00-0000-0000-C000-000000000046");
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_SIPINFO_OBJID, new SpcSipInfo(1, uuid));
        return new SpcIndirectDataContent(data, digestInfo);
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        try {
            DocumentEntry digitalSignature = (DocumentEntry)this.fsRead.getRoot().getEntry(DIGITAL_SIGNATURE_ENTRY_NAME);
            if (digitalSignature != null) {
                byte[] signatureBytes = IOUtils.toByteArray(new DocumentInputStream(digitalSignature));
                return SignatureUtils.getSignatures(signatureBytes);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        if (signature != null) {
            byte[] signatureBytes = signature.toASN1Structure().getEncoded("DER");
            try {
                this.fsWrite.getRoot().createOrUpdateDocument(DIGITAL_SIGNATURE_ENTRY_NAME, new ByteArrayInputStream(signatureBytes));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException("MSI file format error", e);
            }
        } else {
            if (this.fsWrite.getRoot().hasEntry(DIGITAL_SIGNATURE_ENTRY_NAME)) {
                this.fsWrite.getRoot().getEntry(DIGITAL_SIGNATURE_ENTRY_NAME).delete();
            }
            if (this.fsWrite.getRoot().hasEntry(MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME)) {
                this.fsWrite.getRoot().getEntry(MSI_DIGITAL_SIGNATURE_EX_ENTRY_NAME).delete();
            }
        }
    }

    @Override
    public void save() throws IOException {
        int version;
        ByteBuffer directorySectorsCount = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        directorySectorsCount.putInt(this.fsWrite.getPropertyTable().countBlocks()).flip();
        int n = version = this.fsWrite.getBigBlockSize() == 512 ? 3 : 4;
        if (this.channel == null) {
            this.fsWrite.writeFilesystem();
            if (version == 4) {
                this.fsWrite.close();
                try (RandomAccessFile in = new RandomAccessFile(this.file, "rw");){
                    in.seek(40L);
                    in.write(directorySectorsCount.array());
                }
                try {
                    this.fsWrite = new POIFSFileSystem(this.file, false);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException("MSI file format error", e);
                }
            }
            this.fsRead.close();
            try {
                this.fsRead = new POIFSFileSystem(this.file, true);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException("MSI file format error", e);
            }
        }
        this.channel.position(0L);
        this.fsWrite.writeFilesystem(Channels.newOutputStream(this.channel));
        this.channel.truncate(this.channel.position());
        if (version == 4) {
            this.channel.position(40L);
            this.channel.write(directorySectorsCount);
        }
    }
}

