/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.navx;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.List;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcSipInfo;
import net.jsign.asn1.authenticode.SpcUuid;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.DERNull;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.DigestInfo;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.navx.NAVXHeader;
import net.jsign.navx.NAVXSignatureBlock;

public class NAVXFile
implements Signable {
    private final SeekableByteChannel channel;
    private final NAVXHeader header = new NAVXHeader();

    public static boolean isNAVXFile(File file) throws IOException {
        if (file.length() < 40L) {
            return false;
        }
        try (SeekableByteChannel channel = Files.newByteChannel(file.toPath(), StandardOpenOption.READ);){
            ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            channel.read(buffer);
            buffer.flip();
            boolean bl = buffer.getInt() == 1482047822;
            return bl;
        }
    }

    public NAVXFile(File file) throws IOException {
        this(Files.newByteChannel(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE));
    }

    public NAVXFile(SeekableByteChannel channel) throws IOException {
        this.channel = channel;
        channel.position(0L);
        this.header.read(channel);
        if ((long)(this.header.contentSize + 40) > channel.size()) {
            throw new IOException("NAVX file is corrupt: invalid size in the header");
        }
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        MessageDigest digest = digestAlgorithm.getMessageDigest();
        ChannelUtils.updateDigest(this.channel, digest, 0L, this.getSignatureOffset());
        return digest.digest();
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        SpcUuid uuid = new SpcUuid("12341234-F804-0000-781D-123412341234");
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_SIPINFO_OBJID, new SpcSipInfo(1, uuid));
        return new SpcIndirectDataContent(data, digestInfo);
    }

    private int getSignatureOffset() {
        return 40 + this.header.contentSize;
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        this.channel.position(this.getSignatureOffset());
        NAVXSignatureBlock signatureBlock = new NAVXSignatureBlock();
        signatureBlock.read(this.channel);
        return SignatureUtils.getSignatures(signatureBlock.signedData);
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        NAVXSignatureBlock signatureBlock = new NAVXSignatureBlock();
        signatureBlock.signedData = signature;
        this.channel.position(this.getSignatureOffset());
        signatureBlock.write(this.channel);
        this.channel.truncate(this.channel.position());
    }

    @Override
    public void save() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

