/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.navx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import net.jsign.bouncycastle.asn1.ASN1InputStream;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.cms.CMSException;
import net.jsign.bouncycastle.cms.CMSSignedData;

class NAVXSignatureBlock {
    public CMSSignedData signedData;

    NAVXSignatureBlock() {
    }

    public void read(SeekableByteChannel channel) throws IOException {
        int size = (int)(channel.size() - channel.position());
        if (size == 0) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        int signature = buffer.getInt(0);
        if (signature != 1112758350) {
            throw new IOException("Invalid NAVX signature block");
        }
        byte[] signatureBytes = new byte[size - 8];
        buffer.position(4);
        buffer.get(signatureBytes);
        try (ASN1InputStream in = new ASN1InputStream(signatureBytes);){
            this.signedData = new CMSSignedData(null, ContentInfo.getInstance(in.readObject()));
        }
        catch (StackOverflowError | CMSException e) {
            throw new IOException("Invalid CMS signature", e);
        }
    }

    public void write(SeekableByteChannel channel) throws IOException {
        byte[] content;
        long offset = channel.position();
        byte[] byArray = content = this.signedData != null ? this.signedData.toASN1Structure().getEncoded("DER") : new byte[]{};
        if (content.length > 0) {
            ByteBuffer buffer = ByteBuffer.allocate(content.length + 12).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(1112758350);
            buffer.put(content);
            buffer.putInt((int)offset);
            buffer.putInt(1112758350);
            buffer.flip();
            channel.write(buffer);
        }
    }
}

