/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.nuget;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.DERSet;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.esf.CommitmentTypeIndication;
import net.jsign.bouncycastle.asn1.ess.ESSCertIDv2;
import net.jsign.bouncycastle.asn1.ess.SigningCertificateV2;
import net.jsign.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.jsign.bouncycastle.asn1.x500.X500Name;
import net.jsign.bouncycastle.asn1.x509.IssuerSerial;
import net.jsign.bouncycastle.cms.CMSProcessableByteArray;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.CMSTypedData;
import net.jsign.poi.util.IOUtils;
import net.jsign.zip.CentralDirectory;
import net.jsign.zip.ZipFile;

public class NugetFile
extends ZipFile
implements Signable {
    public NugetFile(File file) throws IOException {
        super(file);
        this.verifyPackage();
    }

    private void verifyPackage() throws IOException {
        if (this.centralDirectory.entries.get("[Content_Types].xml") == null) {
            throw new IOException("Invalid NuGet package, [Content_Types].xml is missing");
        }
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        MessageDigest digest = digestAlgorithm.getMessageDigest();
        long endOfContentOffset = this.centralDirectory.centralDirectoryOffset;
        if (this.centralDirectory.entries.containsKey(".signature.p7s")) {
            endOfContentOffset = this.centralDirectory.entries.get(".signature.p7s").getLocalHeaderOffset();
        }
        ChannelUtils.updateDigest(this.channel, digest, 0L, endOfContentOffset);
        digest.update(this.getUnsignedCentralDirectory());
        return String.format("Version:1\n\n%s-Hash:%s\n\n", digestAlgorithm.oid, Base64.getEncoder().encodeToString(digest.digest())).getBytes();
    }

    private byte[] getUnsignedCentralDirectory() throws IOException {
        CentralDirectory centralDirectory = new CentralDirectory();
        centralDirectory.read(this.channel);
        centralDirectory.removeEntry(".signature.p7s");
        return centralDirectory.toBytes();
    }

    @Override
    public CMSTypedData createSignedContent(DigestAlgorithm digestAlgorithm) throws IOException {
        return new CMSProcessableByteArray(PKCSObjectIdentifiers.data, this.computeDigest(digestAlgorithm));
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Attribute> createSignedAttributes(X509Certificate certificate) throws CertificateEncodingException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(PKCSObjectIdentifiers.id_cti_ets_proofOfOrigin);
        attributes.add(new Attribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType, new DERSet(commitmentTypeIndication)));
        byte[] certHash = DigestAlgorithm.SHA256.getMessageDigest().digest(certificate.getEncoded());
        IssuerSerial issuerSerial = new IssuerSerial(X500Name.getInstance(certificate.getIssuerX500Principal().getEncoded()), certificate.getSerialNumber());
        SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(new ESSCertIDv2(certHash, issuerSerial));
        attributes.add(new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new DERSet(signingCertificateV2)));
        return attributes;
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        if (this.centralDirectory.entries.containsKey(".signature.p7s")) {
            InputStream in = this.getInputStream(".signature.p7s", 0x100000);
            return SignatureUtils.getSignatures(IOUtils.toByteArray(in));
        }
        return Collections.emptyList();
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        if (this.centralDirectory.entries.containsKey(".signature.p7s")) {
            this.removeEntry(".signature.p7s");
        }
        if (signature != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            signature.toASN1Structure().encodeTo(out, "DER");
            this.addEntry(".signature.p7s", out.toByteArray(), false);
        }
    }

    @Override
    public void save() throws IOException {
    }
}

