/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.poi.logging;

import net.jsign.log4j.LogManager;
import net.jsign.log4j.Logger;
import net.jsign.poi.logging.NoOpLogger;
import net.jsign.poi.util.ExceptionUtil;

public final class PoiLogManager {
    private static long LAST_TIME = 0L;

    public static Logger getLogger(Class<?> clz) {
        try {
            Logger logger = LogManager.getLogger(clz);
            if (logger == null) {
                if (PoiLogManager.shouldLog()) {
                    System.err.println("[PoiLogManager] Log4J returned null logger. Falling back to No-Op logger.");
                }
                return NoOpLogger.INSTANCE;
            }
            return logger;
        }
        catch (Throwable t) {
            if (!ExceptionUtil.isFatal(t) && PoiLogManager.shouldLog()) {
                System.err.println("[PoiLogManager] Issue loading Log4J. Falling back to No-Op logger.");
                t.printStackTrace();
            }
            return NoOpLogger.INSTANCE;
        }
    }

    private static synchronized boolean shouldLog() {
        long time = System.currentTimeMillis();
        if (time > LAST_TIME + 600000L) {
            LAST_TIME = time;
            return true;
        }
        return false;
    }
}

