/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.poi.poifs.filesystem;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class POIFSDocumentPath {
    private final String[] components;
    private int hashcode;

    public POIFSDocumentPath() {
        this.components = new String[0];
    }

    public POIFSDocumentPath(POIFSDocumentPath path, String[] components) throws IllegalArgumentException {
        Predicate<String> p;
        String[] s1 = path == null ? new String[]{} : path.components;
        String[] s2 = components == null ? new String[]{} : components;
        Predicate<String> predicate = p = path != null ? Objects::isNull : s -> s == null || s.isEmpty();
        if (Stream.of(s2).anyMatch(p)) {
            throw new IllegalArgumentException("components cannot contain null or empty strings");
        }
        this.components = (String[])Stream.concat(Stream.of(s1), Stream.of(s2)).toArray(String[]::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            POIFSDocumentPath path = (POIFSDocumentPath)o;
            return Arrays.equals(this.components, path.components);
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode == 0 ? (this.hashcode = Arrays.hashCode(this.components)) : this.hashcode;
    }

    public String toString() {
        return File.separatorChar + String.join((CharSequence)String.valueOf(File.separatorChar), this.components);
    }
}

