/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.timestamp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jsign.DigestAlgorithm;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.AuthenticodeSignedDataGenerator;
import net.jsign.bouncycastle.asn1.ASN1InputStream;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.cms.AttributeTable;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.asn1.cms.SignedData;
import net.jsign.bouncycastle.cert.X509CertificateHolder;
import net.jsign.bouncycastle.cert.selector.X509CertificateHolderSelector;
import net.jsign.bouncycastle.cms.CMSException;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.CMSSignedDataGenerator;
import net.jsign.bouncycastle.cms.PKCS7ProcessableObject;
import net.jsign.bouncycastle.cms.SignerInformation;
import net.jsign.bouncycastle.cms.SignerInformationStore;
import net.jsign.bouncycastle.util.CollectionStore;
import net.jsign.commons.io.HexDump;
import net.jsign.commons.io.IOUtils;
import net.jsign.timestamp.AuthenticodeTimestamper;
import net.jsign.timestamp.RFC3161Timestamper;
import net.jsign.timestamp.TimestampingException;
import net.jsign.timestamp.TimestampingMode;

public abstract class Timestamper {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected URL tsaurl;
    protected List<URL> tsaurls;
    protected int retries = 3;
    protected int retryWait = 10;

    public void setURL(String tsaurl) {
        this.setURLs(tsaurl);
    }

    public void setURLs(String ... tsaurls) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String tsaurl : tsaurls) {
            try {
                urls.add(new URL(tsaurl));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid timestamping URL: " + tsaurl, e);
            }
        }
        this.tsaurls = urls;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setRetryWait(int retryWait) {
        this.retryWait = retryWait;
    }

    public CMSSignedData timestamp(DigestAlgorithm algo, CMSSignedData sigData) throws TimestampingException, IOException, CMSException {
        CMSSignedData token = null;
        int attempts = Math.max(this.retries, this.tsaurls.size());
        TimestampingException exception = new TimestampingException("Unable to complete the timestamping after " + attempts + " attempt" + (attempts > 1 ? "s" : ""));
        for (int count = 0; count < Math.max(this.retries, this.tsaurls.size()); ++count) {
            if (count > 0) {
                try {
                    long pause = (long)this.retryWait * 1000L;
                    this.log.fine("Timestamping failed, retrying in " + pause / 1000L + " seconds");
                    Thread.sleep(pause);
                }
                catch (InterruptedException pause) {
                    // empty catch block
                }
            }
            try {
                this.tsaurl = this.tsaurls.get(count % this.tsaurls.size());
                this.log.fine("Timestamping with " + this.tsaurl);
                long t0 = System.currentTimeMillis();
                token = this.timestamp(algo, this.getEncryptedDigest(sigData));
                long t1 = System.currentTimeMillis();
                this.log.fine("Timestamping completed in " + (t1 - t0) + " ms");
                break;
            }
            catch (IOException | TimestampingException e) {
                exception.addSuppressed(e);
                continue;
            }
        }
        if (token == null) {
            throw exception;
        }
        return this.modifySignedData(sigData, this.getCounterSignature(token), this.getExtraCertificates(token));
    }

    byte[] post(URL url, byte[] data, Map<String, String> headers) throws IOException {
        this.log.finest("POST " + url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-length", String.valueOf(data.length));
        conn.setRequestProperty("User-Agent", "Transport");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.log.isLoggable(Level.FINEST)) {
            for (String string : conn.getRequestProperties().keySet()) {
                this.log.finest(string + ": " + conn.getRequestProperty(string));
            }
            this.log("Content", data);
        }
        conn.getOutputStream().write(data);
        conn.getOutputStream().flush();
        for (String string : conn.getHeaderFields().keySet()) {
            this.log.finest((string != null ? string + ": " : "") + conn.getHeaderField(string));
        }
        if (conn.getResponseCode() >= 400) {
            byte[] error;
            byte[] byArray = error = conn.getErrorStream() != null ? IOUtils.toByteArray(conn.getErrorStream()) : new byte[]{};
            if (conn.getErrorStream() != null) {
                this.log("Error", error);
            }
            throw new IOException("Unable to complete the timestamping due to HTTP error: " + conn.getResponseCode() + " - " + conn.getResponseMessage());
        }
        byte[] content = IOUtils.toByteArray(conn.getInputStream());
        this.log("Content", content);
        return content;
    }

    private void log(String description, byte[] data) throws IOException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(description + ":");
            StringBuffer out = new StringBuffer();
            HexDump.dump(data, 0L, out, 0, data.length);
            this.log.finest(out.toString());
        }
    }

    private byte[] getEncryptedDigest(CMSSignedData sigData) {
        SignerInformation signerInformation = sigData.getSignerInfos().getSigners().iterator().next();
        return signerInformation.toASN1Structure().getEncryptedDigest().getOctets();
    }

    protected Collection<X509CertificateHolder> getExtraCertificates(CMSSignedData token) {
        return null;
    }

    protected abstract Attribute getCounterSignature(CMSSignedData var1);

    @Deprecated
    protected AttributeTable getUnsignedAttributes(CMSSignedData token) {
        return new AttributeTable(this.getCounterSignature(token));
    }

    @Deprecated
    protected CMSSignedData modifySignedData(CMSSignedData sigData, AttributeTable counterSignature, Collection<X509CertificateHolder> extraCertificates) throws IOException, CMSException {
        return this.modifySignedData(sigData, Attribute.getInstance(counterSignature.toASN1EncodableVector().get(0)), extraCertificates);
    }

    protected CMSSignedData modifySignedData(CMSSignedData sigData, Attribute counterSignature, Collection<X509CertificateHolder> extraCertificates) throws IOException, CMSException {
        SignerInformation signerInformation = sigData.getSignerInfos().getSigners().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        unsignedAttributes = unsignedAttributes == null ? new AttributeTable(counterSignature) : unsignedAttributes.add(counterSignature.getAttrType(), counterSignature.getAttrValues().getObjectAt(0));
        signerInformation = SignerInformation.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
        ArrayList<X509CertificateHolder> certificates = new ArrayList<X509CertificateHolder>(sigData.getCertificates().getMatches(null));
        if (extraCertificates != null) {
            for (X509CertificateHolder certificate : extraCertificates) {
                X509CertificateHolderSelector selector = new X509CertificateHolderSelector(certificate.getIssuer(), certificate.getSerialNumber());
                if (!sigData.getCertificates().getMatches(selector).isEmpty()) continue;
                certificates.add(certificate);
            }
        }
        CollectionStore<X509CertificateHolder> certificateStore = new CollectionStore<X509CertificateHolder>(certificates);
        byte[] encoded = sigData.toASN1Structure().getContent().toASN1Primitive().getEncoded("DER");
        SignedData signedData = SignedData.getInstance(new ASN1InputStream(encoded).readObject());
        ContentInfo content = signedData.getEncapContentInfo();
        PKCS7ProcessableObject signedContent = new PKCS7ProcessableObject(content.getContentType(), content.getContent());
        boolean authenticode = AuthenticodeObjectIdentifiers.isAuthenticode(sigData.getSignedContentTypeOID());
        CMSSignedDataGenerator generator = authenticode ? new AuthenticodeSignedDataGenerator() : new CMSSignedDataGenerator();
        generator.addCertificates(certificateStore);
        generator.addSigners(new SignerInformationStore(signerInformation));
        return generator.generate(signedContent, true);
    }

    protected abstract CMSSignedData timestamp(DigestAlgorithm var1, byte[] var2) throws IOException, TimestampingException;

    public static Timestamper create(TimestampingMode mode) {
        switch (mode) {
            case AUTHENTICODE: {
                return new AuthenticodeTimestamper();
            }
            case RFC3161: {
                return new RFC3161Timestamper();
            }
        }
        throw new IllegalArgumentException("Unsupported timestamping mode: " + (Object)((Object)mode));
    }
}

