/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import net.jsign.zip.ZipRecord;

class EndOfCentralDirectoryRecord
extends ZipRecord {
    public int numberOfThisDisk;
    public int numberOfTheDiskWithTheStartOfTheCentralDirectory;
    public int numberOfEntriesOnThisDisk;
    public int numberOfEntries;
    public int centralDirectorySize;
    public int centralDirectoryOffset;
    public byte[] comment = new byte[0];

    EndOfCentralDirectoryRecord() {
    }

    public void load(SeekableByteChannel channel) throws IOException {
        if (!this.locate(channel)) {
            throw new IOException("End of Central Directory Record not found");
        }
        long position = channel.position();
        this.read(channel);
        channel.position(position);
    }

    public void read(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(22).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        int signature = buffer.getInt();
        if (signature != 101010256) {
            throw new IOException("Invalid End of Central Directory Record signature " + String.format("0x%04x", (long)signature & 0xFFFFFFFFL));
        }
        this.numberOfThisDisk = buffer.getShort();
        this.numberOfTheDiskWithTheStartOfTheCentralDirectory = buffer.getShort();
        this.numberOfEntriesOnThisDisk = buffer.getShort();
        this.numberOfEntries = buffer.getShort();
        this.centralDirectorySize = buffer.getInt();
        this.centralDirectoryOffset = buffer.getInt();
        short commentLength = buffer.getShort();
        if (commentLength > 0) {
            this.comment = new byte[commentLength];
            channel.read(ByteBuffer.wrap(this.comment));
        }
    }

    @Override
    public ByteBuffer toBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(22 + this.comment.length).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(101010256);
        buffer.putShort((short)this.numberOfThisDisk);
        buffer.putShort((short)this.numberOfTheDiskWithTheStartOfTheCentralDirectory);
        buffer.putShort((short)this.numberOfEntriesOnThisDisk);
        buffer.putShort((short)this.numberOfEntries);
        buffer.putInt(this.centralDirectorySize);
        buffer.putInt(this.centralDirectoryOffset);
        buffer.putShort((short)this.comment.length);
        buffer.put(this.comment);
        buffer.flip();
        return buffer;
    }

    public boolean locate(SeekableByteChannel channel) throws IOException {
        long maxOffset;
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        long minOffset = Math.max(0L, channel.size() - 65557L);
        for (long offset = maxOffset = channel.size() - 22L; offset >= minOffset; --offset) {
            channel.position(offset);
            channel.read(buffer);
            buffer.flip();
            if (buffer.getInt() == 101010256) {
                channel.position(offset);
                return true;
            }
            buffer.rewind();
        }
        return false;
    }
}

