/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hid4java.jna.HidApiLibrary;
import org.hid4java.jna.HidDeviceInfoStructure;
import org.hid4java.jna.HidrawHidApiLibrary;

public class DarwinHidApiLibrary
implements HidApiLibrary {
    public static HidApiLibrary INSTANCE = new DarwinHidApiLibrary();
    private static final RealDarwinHidApiLibrary REAL_INSTANCE = (RealDarwinHidApiLibrary)Native.load((String)"hidapi", RealDarwinHidApiLibrary.class);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    @Override
    public void hid_init() {
        try {
            executor.submit(REAL_INSTANCE::hid_init).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void hid_exit() {
        try {
            executor.submit(REAL_INSTANCE::hid_exit).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Pointer hid_open(short vendor_id, short product_id, WString serial_number) {
        try {
            return executor.submit(() -> REAL_INSTANCE.hid_open(vendor_id, product_id, serial_number)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void hid_close(Pointer device) {
        REAL_INSTANCE.hid_close(device);
    }

    @Override
    public Pointer hid_error(Pointer device) {
        return REAL_INSTANCE.hid_error(device);
    }

    @Override
    public int hid_read(Pointer device, Structure.ByReference bytes, int length) {
        return REAL_INSTANCE.hid_read(device, bytes, length);
    }

    @Override
    public int hid_read_timeout(Pointer device, Structure.ByReference bytes, int length, int timeout) {
        return REAL_INSTANCE.hid_read_timeout(device, bytes, length, timeout);
    }

    @Override
    public int hid_write(Pointer device, Structure.ByReference data, int len) {
        return REAL_INSTANCE.hid_write(device, data, len);
    }

    @Override
    public int hid_get_feature_report(Pointer device, Structure.ByReference data, int length) {
        return REAL_INSTANCE.hid_get_feature_report(device, data, length);
    }

    @Override
    public int hid_send_feature_report(Pointer device, Structure.ByReference data, int length) {
        return REAL_INSTANCE.hid_send_feature_report(device, data, length);
    }

    @Override
    public int hid_get_indexed_string(Pointer device, int idx, Structure.ByReference string, int len) {
        return REAL_INSTANCE.hid_get_indexed_string(device, idx, string, len);
    }

    @Override
    public int hid_get_report_descriptor(Pointer device, byte[] buffer, int size) {
        return REAL_INSTANCE.hid_get_report_descriptor(device, buffer, size);
    }

    @Override
    public int hid_get_manufacturer_string(Pointer device, Structure.ByReference str, int len) {
        return REAL_INSTANCE.hid_get_manufacturer_string(device, str, len);
    }

    @Override
    public int hid_get_product_string(Pointer device, Structure.ByReference str, int len) {
        return REAL_INSTANCE.hid_get_product_string(device, str, len);
    }

    @Override
    public int hid_get_serial_number_string(Pointer device, Structure.ByReference str, int len) {
        return REAL_INSTANCE.hid_get_serial_number_string(device, str, len);
    }

    @Override
    public int hid_set_nonblocking(Pointer device, int nonblock) {
        return REAL_INSTANCE.hid_set_nonblocking(device, nonblock);
    }

    @Override
    public HidDeviceInfoStructure hid_enumerate(short vendor_id, short product_id) {
        try {
            return executor.submit(() -> REAL_INSTANCE.hid_enumerate(vendor_id, product_id)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void hid_free_enumeration(Pointer devs) {
        REAL_INSTANCE.hid_free_enumeration(devs);
    }

    @Override
    public Pointer hid_open_path(String path) {
        try {
            return executor.submit(() -> REAL_INSTANCE.hid_open_path(path)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String hid_version_str() {
        return REAL_INSTANCE.hid_version_str();
    }

    public void hid_darwin_set_open_exclusive(int openExclusive) {
        REAL_INSTANCE.hid_darwin_set_open_exclusive(openExclusive);
    }

    private static interface RealDarwinHidApiLibrary
    extends HidrawHidApiLibrary {
        public void hid_darwin_set_open_exclusive(int var1);
    }
}

